/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.java.collections.MapBuilder;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2153")
public class ImmediateReverseBoxingCheck
extends IssuableSubscriptionVisitor {
    private static final Map<String, String> PRIMITIVE_TYPES_BY_WRAPPER = MapBuilder.newMap().put("java.lang.Boolean", "boolean").put("java.lang.Byte", "byte").put("java.lang.Double", "double").put("java.lang.Float", "float").put("java.lang.Integer", "int").put("java.lang.Long", "long").put("java.lang.Short", "short").put("java.lang.Character", "char").build();
    private static final MethodMatchers unboxingInvocationMatchers = ImmediateReverseBoxingCheck.unboxingInvocationMatchers();
    private static final MethodMatchers valueOfInvocationMatchers = ImmediateReverseBoxingCheck.valueOfInvocationMatchers();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD_INVOCATION, Tree.Kind.VARIABLE, Tree.Kind.ASSIGNMENT, Tree.Kind.NEW_CLASS);
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(Tree.Kind.METHOD_INVOCATION)) {
            this.visitMethodInvocationTree((MethodInvocationTree)tree);
        } else if (tree.is(Tree.Kind.VARIABLE)) {
            VariableTree variableTree = (VariableTree)tree;
            ExpressionTree initializer = variableTree.initializer();
            if (initializer != null) {
                this.checkExpression(initializer, variableTree.type().symbolType());
            }
        } else if (tree.is(Tree.Kind.ASSIGNMENT)) {
            AssignmentExpressionTree assignmentTree = (AssignmentExpressionTree)tree;
            this.checkExpression(assignmentTree.expression(), assignmentTree.symbolType());
        } else {
            NewClassTree newClassTree = (NewClassTree)tree;
            Symbol.TypeSymbol classSymbol = ImmediateReverseBoxingCheck.wrapperClassSymbol(newClassTree);
            if (classSymbol != null) {
                ExpressionTree arg0 = (ExpressionTree)newClassTree.arguments().get(0);
                this.checkForUnboxing(arg0);
                this.checkForUselessUnboxing(newClassTree.symbolType(), newClassTree.identifier(), arg0);
            }
        }
    }

    private void checkExpression(ExpressionTree expression, Type implicitType) {
        if (implicitType.isPrimitive()) {
            this.checkForBoxing(expression);
        } else {
            this.checkForUnboxing(expression);
        }
    }

    private void visitMethodInvocationTree(MethodInvocationTree mit) {
        ExpressionTree methodSelect = mit.methodSelect();
        if (ImmediateReverseBoxingCheck.isValueOfInvocation(mit)) {
            ExpressionTree arg0 = (ExpressionTree)mit.arguments().get(0);
            this.checkForUnboxing(arg0);
            this.checkForUselessUnboxing(mit.symbolType(), methodSelect, arg0);
        } else if (ImmediateReverseBoxingCheck.isUnboxingMethodInvocation(mit)) {
            if (methodSelect.is(Tree.Kind.MEMBER_SELECT)) {
                this.checkForBoxing(((MemberSelectExpressionTree)methodSelect).expression());
            }
        } else {
            Symbol symbol = mit.symbol();
            if (symbol.isMethodSymbol()) {
                this.checkMethodInvocationArguments(mit, ((Symbol.MethodSymbol)symbol).parameterTypes());
            }
        }
    }

    private void checkForUselessUnboxing(Type targetType, Tree reportTree, ExpressionTree arg0) {
        Type argType = arg0.symbolType();
        if (argType.is(targetType.fullyQualifiedName())) {
            this.reportIssue(reportTree, String.format("Remove the boxing to \"%s\"; The argument is already of the same type.", argType.name()));
        }
    }

    private void checkMethodInvocationArguments(MethodInvocationTree methodInvocationTree, List<Type> parametersTypes) {
        Arguments arguments = methodInvocationTree.arguments();
        int position = 0;
        for (Type paramType : parametersTypes) {
            if (arguments.size() > position) {
                this.checkExpression((ExpressionTree)arguments.get(position), paramType);
            }
            ++position;
        }
    }

    private void checkForBoxing(ExpressionTree expression) {
        MethodInvocationTree methodInvocationTree;
        if (expression.is(Tree.Kind.NEW_CLASS)) {
            ExpressionTree boxingArg;
            NewClassTree newClassTree = (NewClassTree)expression;
            Symbol.TypeSymbol classSymbol = ImmediateReverseBoxingCheck.wrapperClassSymbol(newClassTree);
            if (classSymbol != null && (boxingArg = (ExpressionTree)newClassTree.arguments().get(0)).symbolType().isPrimitive()) {
                this.addBoxingIssue(newClassTree, classSymbol, boxingArg);
            }
        } else if (expression.is(Tree.Kind.METHOD_INVOCATION) && ImmediateReverseBoxingCheck.isValueOfInvocation(methodInvocationTree = (MethodInvocationTree)expression)) {
            ExpressionTree boxingArg = (ExpressionTree)methodInvocationTree.arguments().get(0);
            this.addBoxingIssue(expression, methodInvocationTree.symbol().owner(), boxingArg);
        }
    }

    private static Symbol.TypeSymbol wrapperClassSymbol(NewClassTree newClassTree) {
        Symbol.TypeSymbol classSymbol = newClassTree.symbolType().symbol();
        if (PRIMITIVE_TYPES_BY_WRAPPER.containsKey(newClassTree.symbolType().fullyQualifiedName()) && !newClassTree.arguments().isEmpty()) {
            return classSymbol;
        }
        return null;
    }

    private void addBoxingIssue(Tree tree, Symbol classSymbol, Tree boxingArg) {
        if (boxingArg.is(Tree.Kind.IDENTIFIER)) {
            IdentifierTree identifier = (IdentifierTree)boxingArg;
            this.reportIssue(tree, "Remove the boxing of \"" + identifier.name() + "\".");
        } else {
            this.reportIssue(tree, "Remove the boxing to \"" + classSymbol.name() + "\".");
        }
    }

    private void checkForUnboxing(ExpressionTree expressionTree) {
        if (!expressionTree.is(Tree.Kind.METHOD_INVOCATION)) {
            return;
        }
        MethodInvocationTree methodInvocationTree = (MethodInvocationTree)expressionTree;
        if (ImmediateReverseBoxingCheck.isUnboxingMethodInvocation(methodInvocationTree)) {
            ExpressionTree methodSelect = methodInvocationTree.methodSelect();
            if (methodSelect.is(Tree.Kind.MEMBER_SELECT)) {
                MemberSelectExpressionTree memberSelectExpressionTree = (MemberSelectExpressionTree)methodSelect;
                ExpressionTree unboxedExpression = memberSelectExpressionTree.expression();
                String unboxingResultTypeName = methodInvocationTree.symbolType().fullyQualifiedName();
                if (unboxingResultTypeName.equals(PRIMITIVE_TYPES_BY_WRAPPER.get(unboxedExpression.symbolType().fullyQualifiedName()))) {
                    this.addUnboxingIssue(expressionTree, unboxedExpression);
                }
            }
        }
    }

    private void addUnboxingIssue(ExpressionTree expressionTree, ExpressionTree expression) {
        if (expression.is(Tree.Kind.IDENTIFIER)) {
            IdentifierTree identifier = (IdentifierTree)expression;
            this.reportIssue(expressionTree, "Remove the unboxing of \"" + identifier.name() + "\".");
        } else {
            String name = expression.symbolType().name();
            this.reportIssue(expressionTree, "Remove the unboxing from \"" + name + "\".");
        }
    }

    private static MethodMatchers unboxingInvocationMatchers() {
        ArrayList<MethodMatchers> matchers = new ArrayList<MethodMatchers>();
        for (Map.Entry<String, String> type : PRIMITIVE_TYPES_BY_WRAPPER.entrySet()) {
            String primitiveType = type.getValue();
            Predicate<Type> typeCriteria = "char".equals(primitiveType) || "boolean".equals(primitiveType) ? t -> t.is((String)type.getKey()) : t -> t.isSubtypeOf("java.lang.Number");
            matchers.add(MethodMatchers.create().ofType(typeCriteria).names(primitiveType + "Value").addWithoutParametersMatcher().build());
        }
        return MethodMatchers.or(matchers);
    }

    private static MethodMatchers valueOfInvocationMatchers() {
        ArrayList<MethodMatchers> matchers = new ArrayList<MethodMatchers>();
        for (Map.Entry<String, String> primitiveMapping : PRIMITIVE_TYPES_BY_WRAPPER.entrySet()) {
            matchers.add(MethodMatchers.create().ofTypes(primitiveMapping.getKey()).names("valueOf").addParametersMatcher(primitiveMapping.getValue()).build());
        }
        return MethodMatchers.or(matchers);
    }

    private static boolean isUnboxingMethodInvocation(MethodInvocationTree mit) {
        return unboxingInvocationMatchers.matches(mit);
    }

    private static boolean isValueOfInvocation(MethodInvocationTree mit) {
        return valueOfInvocationMatchers.matches(mit);
    }
}

