/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="ForLoopCounterChangedCheck", repositoryKey="squid")
@Rule(key="S127")
public class ForLoopCounterChangedCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private final Set<String> loopCounters = new HashSet<String>();
    private JavaFileScannerContext context;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.loopCounters.clear();
        this.scan(context.getTree());
    }

    @Override
    public void visitForStatement(ForStatementTree tree) {
        HashSet<String> pendingLoopCounters = new HashSet<String>();
        for (StatementTree statementTree : tree.initializer()) {
            if (!statementTree.is(Tree.Kind.VARIABLE)) continue;
            pendingLoopCounters.add(((VariableTree)statementTree).simpleName().name());
        }
        this.scan(tree.initializer());
        this.scan(tree.condition());
        this.scan(tree.update());
        this.loopCounters.addAll(pendingLoopCounters);
        this.scan(tree.statement());
        this.loopCounters.removeAll(pendingLoopCounters);
    }

    @Override
    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        if (tree.variable().is(Tree.Kind.IDENTIFIER)) {
            this.checkIdentifier((IdentifierTree)tree.variable());
        }
        super.visitAssignmentExpression(tree);
    }

    @Override
    public void visitUnaryExpression(UnaryExpressionTree tree) {
        if ((ForLoopCounterChangedCheck.isIncrement(tree) || ForLoopCounterChangedCheck.isDecrement(tree)) && tree.expression().is(Tree.Kind.IDENTIFIER)) {
            this.checkIdentifier((IdentifierTree)tree.expression());
        }
        super.visitUnaryExpression(tree);
    }

    private static boolean isIncrement(UnaryExpressionTree tree) {
        return tree.is(Tree.Kind.PREFIX_INCREMENT) || tree.is(Tree.Kind.POSTFIX_INCREMENT);
    }

    private static boolean isDecrement(UnaryExpressionTree tree) {
        return tree.is(Tree.Kind.POSTFIX_DECREMENT) || tree.is(Tree.Kind.PREFIX_DECREMENT);
    }

    private void checkIdentifier(IdentifierTree identifierTree) {
        if (this.loopCounters.contains(identifierTree.name())) {
            this.context.reportIssue(this, identifierTree, "Refactor the code in order to not assign to this loop counter from within the loop body.");
        }
    }
}

