/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1165")
public class ExceptionsShouldBeImmutableCheck
extends IssuableSubscriptionVisitor {
    @Override
    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (ExceptionsShouldBeImmutableCheck.isException(classTree)) {
            for (Tree member : classTree.members()) {
                if (!member.is(Tree.Kind.VARIABLE) || ExceptionsShouldBeImmutableCheck.isFinal((VariableTree)member)) continue;
                IdentifierTree simpleName = ((VariableTree)member).simpleName();
                this.reportIssue(simpleName, "Make this \"" + simpleName.name() + "\" field final.");
            }
        }
    }

    private static boolean isFinal(VariableTree member) {
        return ModifiersUtils.hasModifier(member.modifiers(), Modifier.FINAL);
    }

    private static boolean isException(ClassTree classTree) {
        return classTree.simpleName() != null && classTree.symbol().type().isSubtypeOf("java.lang.Throwable");
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }
}

