/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifierKeywordTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S3066")
public class EnumMutableFieldCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.ENUM);
    }

    @Override
    public void visitNode(Tree tree) {
        ClassTree enumTree = (ClassTree)tree;
        for (Tree member : enumTree.members()) {
            MethodTree methodTree;
            ModifierKeywordTree publicModifier;
            if (member.is(Tree.Kind.VARIABLE)) {
                VariableTree variableTree = (VariableTree)member;
                ModifiersTree modifiers = variableTree.modifiers();
                ModifierKeywordTree publicModifier2 = ModifiersUtils.getModifier(modifiers, Modifier.PUBLIC);
                if (publicModifier2 == null || !EnumMutableFieldCheck.isNotStaticOrFinal(variableTree.modifiers()) && !EnumMutableFieldCheck.isMutableFinalMember(variableTree)) continue;
                this.reportIssue(publicModifier2, "Lower the visibility of this field.");
                continue;
            }
            if (!member.is(Tree.Kind.METHOD) || (publicModifier = ModifiersUtils.getModifier((methodTree = (MethodTree)member).modifiers(), Modifier.PUBLIC)) == null || !EnumMutableFieldCheck.isSetter(methodTree)) continue;
            this.reportIssue(publicModifier, "Lower the visibility of this setter or remove it altogether.");
        }
    }

    private static boolean isNotStaticOrFinal(ModifiersTree modifiersTree) {
        return !ModifiersUtils.hasModifier(modifiersTree, Modifier.STATIC) && !ModifiersUtils.hasModifier(modifiersTree, Modifier.FINAL);
    }

    private static boolean isMutableFinalMember(VariableTree variableTree) {
        ModifiersTree modifiersTree = variableTree.modifiers();
        return !ModifiersUtils.hasModifier(modifiersTree, Modifier.STATIC) && ModifiersUtils.hasModifier(modifiersTree, Modifier.FINAL) && EnumMutableFieldCheck.isMutableMember(variableTree);
    }

    private static boolean isMutableMember(VariableTree variableTree) {
        return variableTree.type().is(Tree.Kind.ARRAY_TYPE) || EnumMutableFieldCheck.isDateOrCollection(variableTree);
    }

    private static boolean isDateOrCollection(VariableTree variableTree) {
        Type type = variableTree.symbol().type();
        return type.is("java.util.Date") || type.isSubtypeOf("java.util.Collection") && !type.isSubtypeOf("com.google.common.collect.ImmutableCollection");
    }

    private static boolean isSetter(MethodTree methodTree) {
        TypeTree returnType = methodTree.returnType();
        BlockTree block = methodTree.block();
        boolean returnsVoid = returnType.is(Tree.Kind.PRIMITIVE_TYPE) && "void".equals(((PrimitiveTypeTree)returnType).keyword().text());
        boolean hasAtLeastOneStatement = block == null || !block.body().isEmpty();
        return methodTree.simpleName().name().startsWith("set") && methodTree.parameters().size() == 1 && returnsVoid && hasAtLeastOneStatement;
    }
}

