/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;

@Rule(key="S2658")
public class DynamicClassLoadCheck
extends AbstractMethodDetection {
    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or(MethodMatchers.create().ofSubTypes("java.lang.Class").names("forName").withAnyParameters().build(), MethodMatchers.create().ofSubTypes("java.lang.ClassLoader").names("loadClass").withAnyParameters().build());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        String stringConstant = ExpressionsHelper.getConstantValueAsString((ExpressionTree)mit.arguments().get(0)).value();
        if (stringConstant == null) {
            this.reportIssue(ExpressionUtils.methodName(mit), "Remove this use of dynamic class loading.");
        }
    }
}

