/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.NewClassTree;

@Rule(key="S4011")
public class DisallowedConstructorCheck
extends AbstractMethodDetection {
    @RuleProperty(key="className", description="Name of the class whose constructor is forbidden. This parameter is mandatory, if absent the rule is disabled.")
    private String className = "";
    @RuleProperty(key="argumentTypes", description="Comma-delimited list of argument types, E.G. java.lang.String, int[], int")
    private String argumentTypes = "";
    @RuleProperty(key="allOverloads", description="Set to true to flag all overloads regardless of parameter type", defaultValue="false")
    private boolean allOverloads = false;

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        if (StringUtils.isEmpty(this.className)) {
            return MethodMatchers.none();
        }
        MethodMatchers.ParametersBuilder invocationMatcher = MethodMatchers.create().ofTypes(this.className).constructor();
        if (this.allOverloads) {
            return invocationMatcher.withAnyParameters().build();
        }
        String[] args = StringUtils.split(this.argumentTypes, ",");
        if (args.length == 0) {
            return invocationMatcher.addWithoutParametersMatcher().build();
        }
        String[] trimmedArgs = new String[args.length];
        for (int i = 0; i < trimmedArgs.length; ++i) {
            trimmedArgs[i] = StringUtils.trim(args[i]);
        }
        return invocationMatcher.addParametersMatcher(trimmedArgs).build();
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        this.reportIssue(newClassTree.identifier(), "Remove this forbidden initialization");
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setArgumentTypes(String argumentTypes) {
        this.argumentTypes = argumentTypes;
    }

    public void setAllOverloads(boolean allOverloads) {
        this.allOverloads = allOverloads;
    }
}

