/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5261")
public class DanglingElseStatementsCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.IF_STATEMENT);
    }

    @Override
    public void visitNode(Tree tree) {
        IfStatementTree ifstmt = (IfStatementTree)tree;
        if (DanglingElseStatementsCheck.hasElse(ifstmt) && DanglingElseStatementsCheck.isNested(ifstmt)) {
            this.reportIssue(ifstmt.elseKeyword(), "Add explicit curly braces to avoid dangling else.");
        }
    }

    private static boolean hasElse(IfStatementTree ifstmt) {
        return ifstmt.elseStatement() != null;
    }

    private static boolean isNested(IfStatementTree ifstmt) {
        return ifstmt.parent().is(Tree.Kind.IF_STATEMENT) && ((IfStatementTree)ifstmt.parent()).thenStatement() == ifstmt;
    }
}

