/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;

@Rule(key="S2185")
public class ConstantMathCheck
extends IssuableSubscriptionVisitor {
    private static final String ABS = "abs";
    private static final String CEIL = "ceil";
    private static final String DOUBLE = "double";
    private static final String FLOAT = "float";
    private static final String FLOOR = "floor";
    private static final String MATH_PACKAGE_NAME = "java.lang.Math";
    private static final String ROUND = "round";
    private static final MethodMatchers CONSTANT_WITH_LITERAL_METHODS = MethodMatchers.create().ofTypes("java.lang.Math").names("abs").addParametersMatcher("double").addParametersMatcher("float").addParametersMatcher("int").addParametersMatcher("long").build();
    private static final MethodMatchers TRUNCATION_METHODS = MethodMatchers.or(MethodMatchers.create().ofTypes("java.lang.Math").names("ceil").addParametersMatcher("double").addParametersMatcher("float").build(), MethodMatchers.create().ofTypes("java.lang.Math").names("floor").addParametersMatcher("double").addParametersMatcher("float").build(), MethodMatchers.create().ofTypes("java.lang.Math").names("rint").addParametersMatcher("double").build(), MethodMatchers.create().ofTypes("java.lang.Math").names("round").addParametersMatcher("double").addParametersMatcher("float").build());
    private static final MethodMatchers CONSTANT_WITH_ZERO_METHODS = MethodMatchers.or(MethodMatchers.create().ofTypes("java.lang.Math").names("atan2").addParametersMatcher("double", "double").build(), MethodMatchers.create().ofTypes("java.lang.Math").names("cos", "cosh", "expm1", "sin", "sinh", "tan", "tanh", "toRadians").addParametersMatcher("double").build());
    private static final MethodMatchers CONSTANT_WITH_ZERO_OR_ONE_METHODS = MethodMatchers.create().ofTypes("java.lang.Math").names("acos", "asin", "atan", "cbrt", "exp", "log", "log10", "sqrt", "toDegrees").addParametersMatcher("double").build();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.REMAINDER, Tree.Kind.METHOD_INVOCATION);
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(Tree.Kind.REMAINDER)) {
            BinaryExpressionTree remainderTree = (BinaryExpressionTree)tree;
            if (ConstantMathCheck.isIntegralOne(remainderTree.rightOperand()) && ConstantMathCheck.isIntOrLong(remainderTree.leftOperand())) {
                this.reportIssue(remainderTree.operatorToken(), "Remove this computation of % 1, which always evaluates to zero.");
            }
        } else {
            MethodInvocationTree mit = (MethodInvocationTree)tree;
            if (ConstantMathCheck.isConstantWithLiteral(mit) || ConstantMathCheck.isTruncation(mit) || ConstantMathCheck.isConstantWithZero(mit) || ConstantMathCheck.isConstantWithZeroOrOne(mit)) {
                this.reportIssue(mit.methodSelect(), String.format("Remove this silly call to \"Math.%s\"", mit.symbol().name()));
            }
        }
    }

    private static boolean isIntOrLong(ExpressionTree expression) {
        Type type = expression.symbolType();
        return ConstantMathCheck.isIntegral(type) || JUtils.isPrimitiveWrapper(type) && ConstantMathCheck.isIntegral(JUtils.primitiveType(type));
    }

    private static boolean isTruncation(MethodInvocationTree methodTree) {
        return TRUNCATION_METHODS.matches(methodTree) && ConstantMathCheck.isCastFromIntegralToFloating(ExpressionUtils.skipParentheses((ExpressionTree)methodTree.arguments().get(0)));
    }

    private static boolean isConstantWithLiteral(MethodInvocationTree methodTree) {
        return CONSTANT_WITH_LITERAL_METHODS.matches(methodTree) && ConstantMathCheck.isConstant((ExpressionTree)methodTree.arguments().get(0));
    }

    private static boolean isConstantWithZero(MethodInvocationTree methodTree) {
        return CONSTANT_WITH_ZERO_METHODS.matches(methodTree) && ConstantMathCheck.isFloatingZero((ExpressionTree)methodTree.arguments().get(0));
    }

    private static boolean isConstantWithZeroOrOne(MethodInvocationTree methodTree) {
        return CONSTANT_WITH_ZERO_OR_ONE_METHODS.matches(methodTree) && ConstantMathCheck.isFloatingZeroOrOne((ExpressionTree)methodTree.arguments().get(0));
    }

    private static boolean isCastFromIntegralToFloating(ExpressionTree tree) {
        Type resultType = tree.symbolType();
        if (tree.is(Tree.Kind.TYPE_CAST) && ConstantMathCheck.isIntegral(ConstantMathCheck.getInnerType(((TypeCastTree)tree).expression())) && (resultType.is(DOUBLE) || resultType.is(FLOAT))) {
            return true;
        }
        return ConstantMathCheck.isIntegral(resultType);
    }

    private static boolean isConstant(ExpressionTree tree) {
        return ConstantMathCheck.getInnerExpression(tree).is(Tree.Kind.CHAR_LITERAL, Tree.Kind.DOUBLE_LITERAL, Tree.Kind.FLOAT_LITERAL, Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL);
    }

    private static boolean isIntegral(Type type) {
        return type.isPrimitive() && !type.is(DOUBLE) && !type.is(FLOAT);
    }

    private static boolean isIntegralOne(ExpressionTree tree) {
        Long value = LiteralUtils.longLiteralValue(tree);
        return value != null && value == 1L;
    }

    private static ExpressionTree getInnerExpression(ExpressionTree tree) {
        ExpressionTree result = ExpressionUtils.skipParentheses(tree);
        while (result.is(Tree.Kind.TYPE_CAST)) {
            result = ExpressionUtils.skipParentheses(((TypeCastTree)result).expression());
        }
        return result;
    }

    private static Type getInnerType(ExpressionTree tree) {
        return ConstantMathCheck.getInnerExpression(tree).symbolType();
    }

    private static boolean isFloatingZero(ExpressionTree tree) {
        Integer value = ConstantMathCheck.getFloatingZeroOrOne(tree);
        return value != null && value == 0;
    }

    private static boolean isFloatingZeroOrOne(ExpressionTree tree) {
        return ConstantMathCheck.getFloatingZeroOrOne(tree) != null;
    }

    @CheckForNull
    private static Integer getFloatingZeroOrOne(ExpressionTree tree) {
        ExpressionTree expressionTree = ExpressionUtils.skipParentheses(tree);
        if (expressionTree.is(Tree.Kind.DOUBLE_LITERAL, Tree.Kind.FLOAT_LITERAL)) {
            String value = ((LiteralTree)expressionTree).value();
            if ("0.0".equals(value) || "0.0d".equalsIgnoreCase(value) || "0.0f".equalsIgnoreCase(value)) {
                return 0;
            }
            if ("1.0".equals(value) || "1.0d".equalsIgnoreCase(value) || "1.0f".equalsIgnoreCase(value)) {
                return 1;
            }
        }
        return null;
    }
}

