/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1155")
public class CollectionIsEmptyCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String JAVA_UTIL_COLLECTION = "java.util.Collection";
    private static final MethodMatchers SIZE_METHOD = MethodMatchers.create().ofSubTypes("java.util.Collection").names("size").addWithoutParametersMatcher().build();
    private JavaFileScannerContext context;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan(context.getTree());
    }

    @Override
    public void visitClass(ClassTree tree) {
        for (Tree member : tree.members()) {
            if (tree.symbol().type().isSubtypeOf(JAVA_UTIL_COLLECTION) && member.is(Tree.Kind.METHOD)) continue;
            this.scan(member);
        }
    }

    @Override
    public void visitBinaryExpression(BinaryExpressionTree tree) {
        super.visitBinaryExpression(tree);
        if (CollectionIsEmptyCheck.hasCallToSizeMethod(tree) && CollectionIsEmptyCheck.isEmptyComparison(tree)) {
            this.context.reportIssue(this, tree, "Use isEmpty() to check whether the collection is empty or not.");
        }
    }

    private static boolean hasCallToSizeMethod(BinaryExpressionTree tree) {
        return CollectionIsEmptyCheck.isCallToSizeMethod(tree.leftOperand()) || CollectionIsEmptyCheck.isCallToSizeMethod(tree.rightOperand());
    }

    private static boolean isCallToSizeMethod(ExpressionTree tree) {
        if (!tree.is(Tree.Kind.METHOD_INVOCATION)) {
            return false;
        }
        return SIZE_METHOD.matches((MethodInvocationTree)tree);
    }

    private static boolean isEmptyComparison(BinaryExpressionTree tree) {
        boolean result = CollectionIsEmptyCheck.isEqualityExpression(tree) ? LiteralUtils.isZero(tree.leftOperand()) || LiteralUtils.isZero(tree.rightOperand()) : (tree.is(Tree.Kind.GREATER_THAN_OR_EQUAL_TO) || tree.is(Tree.Kind.LESS_THAN) ? LiteralUtils.isZero(tree.leftOperand()) || LiteralUtils.isOne(tree.rightOperand()) : (tree.is(Tree.Kind.GREATER_THAN) || tree.is(Tree.Kind.LESS_THAN_OR_EQUAL_TO) ? LiteralUtils.isOne(tree.leftOperand()) || LiteralUtils.isZero(tree.rightOperand()) : false));
        return result;
    }

    private static boolean isEqualityExpression(BinaryExpressionTree tree) {
        return tree.is(Tree.Kind.EQUAL_TO) || tree.is(Tree.Kind.NOT_EQUAL_TO);
    }
}

