/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="ClassVariableVisibilityCheck", repositoryKey="squid")
@Rule(key="S1104")
public class ClassVariableVisibilityCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private Deque<Boolean> isClassStack = new ArrayDeque<Boolean>();
    private JavaFileScannerContext context;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan(context.getTree());
    }

    @Override
    public void visitClass(ClassTree tree) {
        this.isClassStack.push(tree.is(Tree.Kind.CLASS) || tree.is(Tree.Kind.ENUM));
        super.visitClass(tree);
        this.isClassStack.pop();
    }

    @Override
    public void visitVariable(VariableTree tree) {
        ModifiersTree modifiers = tree.modifiers();
        List<AnnotationTree> annotations = modifiers.annotations();
        if (this.isClass() && ClassVariableVisibilityCheck.isPublic(modifiers) && !ClassVariableVisibilityCheck.isFinal(modifiers) && annotations.isEmpty()) {
            this.context.reportIssue(this, tree.simpleName(), "Make " + tree.simpleName() + " a static final constant or non-public and provide accessors if needed.");
        }
        super.visitVariable(tree);
    }

    private boolean isClass() {
        return !this.isClassStack.isEmpty() && this.isClassStack.peek() != false;
    }

    private static boolean isFinal(ModifiersTree modifiers) {
        return ModifiersUtils.hasModifier(modifiers, Modifier.FINAL);
    }

    private static boolean isPublic(ModifiersTree modifiers) {
        return ModifiersUtils.hasModifier(modifiers, Modifier.PUBLIC);
    }
}

