/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.se.NullableAnnotationUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2447")
public class BooleanMethodReturnCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    @Override
    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        SymbolMetadata metadata = methodTree.symbol().metadata();
        if (BooleanMethodReturnCheck.returnsBoolean(methodTree) && !NullableAnnotationUtils.isAnnotatedNullable(metadata) && !BooleanMethodReturnCheck.hasUnknownAnnotation(metadata)) {
            methodTree.accept(new ReturnStatementVisitor());
        }
    }

    private static boolean returnsBoolean(MethodTree methodTree) {
        return methodTree.returnType().symbolType().is("java.lang.Boolean");
    }

    private static boolean hasUnknownAnnotation(SymbolMetadata symbolMetadata) {
        return symbolMetadata.annotations().stream().anyMatch(annotation -> annotation.symbol().isUnknown());
    }

    private class ReturnStatementVisitor
    extends BaseTreeVisitor {
        private ReturnStatementVisitor() {
        }

        @Override
        public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        }

        @Override
        public void visitReturnStatement(ReturnStatementTree tree) {
            if (tree.expression().is(Tree.Kind.NULL_LITERAL)) {
                BooleanMethodReturnCheck.this.reportIssue(tree.expression(), "Null is returned but a \"Boolean\" is expected.");
            }
        }

        @Override
        public void visitClass(ClassTree tree) {
        }
    }
}

