/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.cfg.CFG;
import org.sonar.java.se.AlwaysTrueOrFalseExpressionCollector;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.ExplodedGraphWalker;
import org.sonar.java.se.Flow;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.java.se.xproc.MethodBehavior;
import org.sonar.java.se.xproc.MethodYield;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.performance.measure.PerformanceMeasure;

public class CheckerDispatcher
implements CheckerContext {
    private final ExplodedGraphWalker explodedGraphWalker;
    private final List<SECheck> checks;
    private int currentCheckerIndex = -1;
    private boolean transition = false;
    private Exception interruptionCause = null;
    private final JavaFileScannerContext scannerContext;
    Tree syntaxNode;
    @Nullable
    MethodYield methodYield = null;

    public CheckerDispatcher(ExplodedGraphWalker explodedGraphWalker, List<SECheck> checks, JavaFileScannerContext scannerContext) {
        this.explodedGraphWalker = explodedGraphWalker;
        this.checks = checks;
        this.scannerContext = scannerContext;
    }

    public boolean executeCheckPreStatement(Tree syntaxNode) {
        this.syntaxNode = syntaxNode;
        for (SECheck checker : this.checks) {
            PerformanceMeasure.Duration checkerDuration = PerformanceMeasure.start((Object)checker);
            ProgramState ps = checker.checkPreStatement(this, syntaxNode);
            checkerDuration.stop();
            if (ps == null) {
                return false;
            }
            this.explodedGraphWalker.programState = ps;
        }
        return true;
    }

    public void executeCheckPostStatement(Tree syntaxNode) {
        this.syntaxNode = syntaxNode;
        this.addTransition(this.explodedGraphWalker.programState);
    }

    @Override
    public ProgramState getState() {
        return this.explodedGraphWalker.programState;
    }

    @Override
    public ExplodedGraph.Node getNode() {
        return this.explodedGraphWalker.node;
    }

    @Override
    public void reportIssue(Tree tree, SECheck check, String message) {
        this.reportIssue(tree, check, message, Collections.emptySet());
    }

    @Override
    public void reportIssue(Tree tree, SECheck check, String message, Set<Flow> flows) {
        check.reportIssue(tree, message, flows);
    }

    @Override
    public void addTransition(ProgramState state) {
        ProgramState oldState = this.explodedGraphWalker.programState;
        this.explodedGraphWalker.programState = state;
        ++this.currentCheckerIndex;
        this.executePost();
        --this.currentCheckerIndex;
        this.explodedGraphWalker.programState = oldState;
        this.transition = true;
    }

    private void executePost() {
        this.transition = false;
        if (this.currentCheckerIndex >= this.checks.size()) {
            CFG.Block block = (CFG.Block)this.explodedGraphWalker.programPosition.block;
            if (this.explodedGraphWalker.programPosition.i < block.elements().size()) {
                this.explodedGraphWalker.cleanupStack((Tree)block.elements().get(this.explodedGraphWalker.programPosition.i));
            }
            this.explodedGraphWalker.enqueue(this.explodedGraphWalker.programPosition.next(), this.explodedGraphWalker.programState, this.explodedGraphWalker.node.exitPath, this.methodYield);
            return;
        }
        this.explodedGraphWalker.programState = this.checks.get(this.currentCheckerIndex).checkPostStatement(this, this.syntaxNode);
        if (!this.transition) {
            this.addTransition(this.explodedGraphWalker.programState);
        }
    }

    @Override
    public void addExceptionalYield(SymbolicValue target, ProgramState exceptionalState, String exceptionFullyQualifiedName, SECheck check) {
        this.explodedGraphWalker.addExceptionalYield(target, exceptionalState, exceptionFullyQualifiedName, check);
    }

    @Override
    public Object createSink() {
        this.transition = true;
        return new Object();
    }

    public void executeCheckEndOfExecution() {
        for (SECheck checker : this.checks) {
            PerformanceMeasure.Duration checkerDuration = PerformanceMeasure.start((Object)checker);
            checker.checkEndOfExecution(this);
            checkerDuration.stop();
        }
    }

    public void executeCheckEndOfExecutionPath(ConstraintManager constraintManager) {
        for (SECheck checker : this.checks) {
            PerformanceMeasure.Duration checkerDuration = PerformanceMeasure.start((Object)checker);
            checker.checkEndOfExecutionPath(this, constraintManager);
            checkerDuration.stop();
        }
    }

    public void init(MethodTree methodTree, CFG cfg) {
        for (SECheck checker : this.checks) {
            PerformanceMeasure.Duration checkerDuration = PerformanceMeasure.start((Object)checker);
            checker.init(methodTree, cfg);
            checkerDuration.stop();
        }
    }

    @Override
    public ConstraintManager getConstraintManager() {
        return this.explodedGraphWalker.constraintManager;
    }

    public void interruptedExecution(Exception interruptionCause) {
        this.interruptionCause = interruptionCause;
        this.checks.forEach(c -> c.interruptedExecution(this));
        this.interruptionCause = null;
    }

    @CheckForNull
    public Exception interruptionCause() {
        return this.interruptionCause;
    }

    @Override
    public AlwaysTrueOrFalseExpressionCollector alwaysTrueOrFalseExpressions() {
        return this.explodedGraphWalker.alwaysTrueOrFalseExpressionCollector();
    }

    @Override
    public JavaFileScannerContext getScannerContext() {
        return this.scannerContext;
    }

    @CheckForNull
    public MethodBehavior methodBehavior() {
        return this.explodedGraphWalker.methodBehavior;
    }

    @CheckForNull
    public MethodBehavior peekMethodBehavior(Symbol.MethodSymbol symbol) {
        return this.explodedGraphWalker.peekMethodBehavior(symbol);
    }
}

