/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.surefire;

import java.io.File;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.Settings;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.surefire.SurefireJavaParser;
import org.sonar.plugins.surefire.api.SurefireUtils;

@DependedUpon(value={"surefire-java"})
public class SurefireSensor
implements Sensor {
    private static final Logger LOGGER = Loggers.get(SurefireSensor.class);
    private final SurefireJavaParser surefireJavaParser;
    private final Settings settings;
    private final FileSystem fs;
    private final PathResolver pathResolver;

    public SurefireSensor(SurefireJavaParser surefireJavaParser, Settings settings, FileSystem fs, PathResolver pathResolver) {
        this.surefireJavaParser = surefireJavaParser;
        this.settings = settings;
        this.fs = fs;
        this.pathResolver = pathResolver;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("java").name("SurefireSensor");
    }

    public void execute(SensorContext context) {
        File dir = SurefireUtils.getReportsDirectory(this.settings, this.fs, this.pathResolver);
        this.collect(context, dir);
    }

    protected void collect(SensorContext context, File reportsDir) {
        LOGGER.info("parsing {}", (Object)reportsDir);
        this.surefireJavaParser.collect(context, reportsDir, this.settings.hasKey("sonar.junit.reportsPath"));
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

