/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.regex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.sonar.java.AnalyzerMessage;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.regex.JavaRegexSource;
import org.sonarsource.analyzer.commons.regex.ast.IndexRange;

public class JavaAnalyzerRegexSource
extends JavaRegexSource {
    private final TextSpanTracker indexToTextSpan = new TextSpanTracker();

    public JavaAnalyzerRegexSource(List<LiteralTree> stringLiterals) {
        super(JavaAnalyzerRegexSource.literalsToString(stringLiterals));
        for (LiteralTree literal : stringLiterals) {
            String text = JavaAnalyzerRegexSource.getString(literal);
            this.indexToTextSpan.addLiteral(literal, text.length());
        }
    }

    private static String literalsToString(List<LiteralTree> stringLiterals) {
        StringBuilder sb = new StringBuilder();
        for (LiteralTree literal : stringLiterals) {
            String text = JavaAnalyzerRegexSource.getString(literal);
            sb.append(text);
        }
        return sb.toString();
    }

    public List<AnalyzerMessage.TextSpan> textSpansFor(IndexRange range) {
        ArrayList<AnalyzerMessage.TextSpan> result = new ArrayList<AnalyzerMessage.TextSpan>();
        TextSpanEntry startEntry = this.indexToTextSpan.entryAtIndex(range.getBeginningOffset());
        if (range.getBeginningOffset() < 0) {
            startEntry = this.indexToTextSpan.entryAtIndex(0);
        }
        int startOffset = range.getBeginningOffset() - startEntry.startIndex;
        TextSpanEntry endEntry = this.indexToTextSpan.entryBeforeIndex(range.getEndingOffset());
        if (range.getEndingOffset() <= 0) {
            endEntry = startEntry;
        }
        int endOffset = range.getEndingOffset() - endEntry.startIndex;
        AnalyzerMessage.TextSpan startSpan = startEntry.textSpan;
        AnalyzerMessage.TextSpan endSpan = endEntry.textSpan;
        if (startSpan == endSpan) {
            if (startSpan.onLine()) {
                result.add(startSpan);
            } else {
                AnalyzerMessage.TextSpan newTextSpan = new AnalyzerMessage.TextSpan(startSpan.startLine, startSpan.startCharacter + startOffset, startSpan.endLine, startSpan.startCharacter + endOffset);
                if (this.shouldUseLine(startSpan, newTextSpan)) {
                    result.add(new AnalyzerMessage.TextSpan(newTextSpan.startLine));
                } else {
                    result.add(newTextSpan);
                }
            }
        } else {
            result.add(new AnalyzerMessage.TextSpan(startSpan.startLine, startSpan.startCharacter + startOffset, startSpan.endLine, startSpan.endCharacter));
            int indexAfterStartSpan = startEntry.startIndex + startSpan.endCharacter - startSpan.startCharacter;
            result.addAll(this.indexToTextSpan.textSpansBetween(indexAfterStartSpan, endEntry.startIndex));
            result.add(new AnalyzerMessage.TextSpan(endSpan.startLine, endSpan.startCharacter, endSpan.endLine, endSpan.startCharacter + endOffset));
        }
        return result;
    }

    boolean shouldUseLine(AnalyzerMessage.TextSpan textSpan, AnalyzerMessage.TextSpan newTextSpan) {
        if (newTextSpan.endCharacter <= textSpan.endCharacter) {
            return false;
        }
        LiteralTree literal = this.indexToTextSpan.getLiteral(textSpan);
        if (literal == null || !literal.is(Tree.Kind.TEXT_BLOCK)) {
            return false;
        }
        int lastLine = literal.token().line() + literal.value().split("\n").length - 1;
        return textSpan.endLine != lastLine;
    }

    private static String getString(LiteralTree literal) {
        return literal.asConstant(String.class).orElseThrow(() -> new IllegalArgumentException("Only string literals allowed"));
    }

    private static class TextSpanTracker {
        final NavigableMap<Integer, AnalyzerMessage.TextSpan> indexToTextSpan = new TreeMap<Integer, AnalyzerMessage.TextSpan>();
        final Map<AnalyzerMessage.TextSpan, LiteralTree> textSpanToLiteral = new HashMap<AnalyzerMessage.TextSpan, LiteralTree>();
        int index = 0;

        private TextSpanTracker() {
        }

        void addLiteral(LiteralTree literal, int length) {
            if (literal.is(Tree.Kind.TEXT_BLOCK)) {
                this.addTextBlock(literal);
            } else {
                this.addStringLiteral(literal, length);
            }
        }

        void addStringLiteral(LiteralTree literal, int length) {
            AnalyzerMessage.TextSpan literalSpan = AnalyzerMessage.textSpanFor(literal);
            AnalyzerMessage.TextSpan textSpan = new AnalyzerMessage.TextSpan(literalSpan.startLine, literalSpan.startCharacter + 1, literalSpan.endLine, literalSpan.endCharacter - 1);
            this.indexToTextSpan.put(this.index, textSpan);
            this.textSpanToLiteral.put(textSpan, literal);
            this.index += length;
        }

        void addTextBlock(LiteralTree literal) {
            String[] literalTreeLines = literal.value().split("\n");
            String[] stringLines = JavaAnalyzerRegexSource.getString(literal).split("(?<=\r?\n)");
            int indent = LiteralUtils.indentationOfTextBlock(literalTreeLines);
            int textBlockLine = literal.token().line();
            for (int i = 0; i < stringLines.length; ++i) {
                AnalyzerMessage.TextSpan textSpan;
                int line = textBlockLine + i + 1;
                String stringLine = stringLines[i];
                int lineLength = stringLine.length();
                if (stringLine.trim().isEmpty()) {
                    textSpan = new AnalyzerMessage.TextSpan(line);
                } else {
                    int endLineTrimming = stringLine.endsWith("\n") ? 1 : 0;
                    textSpan = new AnalyzerMessage.TextSpan(line, indent, line, indent + lineLength - endLineTrimming);
                }
                this.indexToTextSpan.put(this.index, textSpan);
                this.textSpanToLiteral.put(textSpan, literal);
                this.index += lineLength;
            }
        }

        @Nullable
        TextSpanEntry entryAtIndex(Integer index) {
            return this.entry(this.indexToTextSpan.floorEntry(index));
        }

        @Nullable
        TextSpanEntry entryBeforeIndex(Integer index) {
            return this.entry(this.indexToTextSpan.lowerEntry(index));
        }

        @Nullable
        LiteralTree getLiteral(AnalyzerMessage.TextSpan textSpan) {
            return this.textSpanToLiteral.get(textSpan);
        }

        @Nullable
        TextSpanEntry entry(@Nullable Map.Entry<Integer, AnalyzerMessage.TextSpan> e) {
            if (e == null) {
                return null;
            }
            return new TextSpanEntry(e);
        }

        Collection<AnalyzerMessage.TextSpan> textSpansBetween(Integer startIndex, Integer endIndex) {
            return this.indexToTextSpan.subMap(startIndex, endIndex).values();
        }
    }

    private static class TextSpanEntry {
        final int startIndex;
        final AnalyzerMessage.TextSpan textSpan;

        TextSpanEntry(Map.Entry<Integer, AnalyzerMessage.TextSpan> entry) {
            this.startIndex = entry.getKey();
            this.textSpan = entry.getValue();
        }
    }
}

