/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.declaration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.sonar.java.collections.ListUtils;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.Symbols;
import org.sonar.java.model.declaration.ModifiersTreeImpl;
import org.sonar.java.model.expression.IdentifierTreeImpl;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.InferedTypeTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class VariableTreeImpl
extends JavaTree
implements VariableTree {
    private ModifiersTree modifiers;
    private TypeTree type;
    private IdentifierTree simpleName;
    @Nullable
    private SyntaxToken equalToken;
    @Nullable
    private ExpressionTree initializer;
    @Nullable
    private SyntaxToken endToken;
    public IVariableBinding variableBinding;

    public VariableTreeImpl(ModifiersTree modifiers, TypeTree type, IdentifierTree simpleName) {
        this.modifiers = modifiers;
        this.type = type;
        this.simpleName = simpleName;
    }

    public VariableTreeImpl(IdentifierTreeImpl simpleName) {
        this.modifiers = ModifiersTreeImpl.emptyModifiers();
        this.simpleName = simpleName;
        this.initializer = null;
        this.type = new InferedTypeTree();
    }

    public VariableTreeImpl(ModifiersTree modifiers, IdentifierTree simpleName, @Nullable ExpressionTree initializer) {
        this.modifiers = Objects.requireNonNull(modifiers);
        this.simpleName = Objects.requireNonNull(simpleName);
        this.initializer = initializer;
    }

    public VariableTreeImpl completeType(TypeTree type) {
        this.type = type;
        return this;
    }

    public VariableTreeImpl completeModifiers(ModifiersTreeImpl modifiers) {
        this.modifiers = modifiers;
        return this;
    }

    public VariableTreeImpl completeModifiersAndType(ModifiersTreeImpl modifiers, TypeTree type) {
        return this.completeModifiers(modifiers).completeType(type);
    }

    public VariableTreeImpl completeTypeAndInitializer(TypeTree type, InternalSyntaxToken equalToken, ExpressionTree initializer) {
        this.initializer = initializer;
        this.equalToken = equalToken;
        return this.completeType(type);
    }

    @Override
    public Tree.Kind kind() {
        return Tree.Kind.VARIABLE;
    }

    @Override
    public ModifiersTree modifiers() {
        return this.modifiers;
    }

    @Override
    public TypeTree type() {
        return this.type;
    }

    @Override
    public IdentifierTree simpleName() {
        return this.simpleName;
    }

    @Override
    @Nullable
    public ExpressionTree initializer() {
        return this.initializer;
    }

    @Override
    @Nullable
    public SyntaxToken equalToken() {
        return this.equalToken;
    }

    @Override
    public Symbol symbol() {
        return this.variableBinding != null ? this.root.sema.variableSymbol(this.variableBinding) : Symbols.unknownSymbol;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitVariable(this);
    }

    @Override
    public int getLine() {
        return ((IdentifierTreeImpl)this.simpleName()).getLine();
    }

    @Override
    public List<Tree> children() {
        return ListUtils.concat(Arrays.asList(this.modifiers, this.type, this.simpleName), this.initializer != null ? Arrays.asList(this.equalToken, this.initializer) : Collections.emptyList(), this.endToken != null ? Collections.singletonList(this.endToken) : Collections.emptyList());
    }

    @Override
    @CheckForNull
    public SyntaxToken endToken() {
        return this.endToken;
    }

    public void setEndToken(InternalSyntaxToken endToken) {
        this.endToken = endToken;
    }
}

