/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.java.collections.SetUtils;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

public final class JWarning {
    private final String message;
    private final Type type;
    private final Position start;
    private final Position end;
    private Tree syntaxTree;

    @VisibleForTesting
    JWarning(String message, Type type, int startLine, int startColumn, int endLine, int endColumn) {
        this.message = message;
        this.type = type;
        this.start = Position.exact(startLine, startColumn);
        this.end = Position.exact(endLine, endColumn);
    }

    public Type type() {
        return this.type;
    }

    public String message() {
        return this.message;
    }

    public Tree syntaxTree() {
        return this.syntaxTree;
    }

    Position start() {
        return this.start;
    }

    Position end() {
        return this.end;
    }

    public static enum Type {
        UNUSED_IMPORT(268435844, "org.eclipse.jdt.core.compiler.problem.unusedImport", Tree.Kind.IMPORT),
        REDUNDANT_CAST(553648309, "org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", Tree.Kind.TYPE_CAST, Tree.Kind.PARENTHESIZED_EXPRESSION),
        ASSIGNMENT_HAS_NO_EFFECT(0x200000B2, "org.eclipse.jdt.core.compiler.problem.noEffectAssignment", Tree.Kind.ASSIGNMENT),
        MASKED_CATCH(16777381, "org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", Tree.Kind.IDENTIFIER, Tree.Kind.MEMBER_SELECT);

        private final int warningID;
        private final String compilerOptionKey;
        private final Set<Tree.Kind> kinds;
        private static final Set<String> COMPILER_OPTIONS;

        private Type(int warningID, String compilerOptionKey, Tree.Kind ... kinds) {
            this.warningID = warningID;
            this.compilerOptionKey = compilerOptionKey;
            this.kinds = SetUtils.immutableSetOf(kinds);
        }

        private boolean matches(IProblem warning) {
            return warning.getID() == this.warningID;
        }

        public static Set<String> compilerOptions() {
            if (COMPILER_OPTIONS.isEmpty()) {
                Stream.of(Type.values()).map(t -> t.compilerOptionKey).forEach(COMPILER_OPTIONS::add);
            }
            return Collections.unmodifiableSet(COMPILER_OPTIONS);
        }

        static {
            COMPILER_OPTIONS = new HashSet<String>();
        }
    }

    private static class Position
    implements Comparable<Position> {
        private static final Comparator<Position> COMPARATOR = Comparator.comparing(Position::line).thenComparing(Position::column);
        private final int line;
        private final int column;

        private Position(int line, int column) {
            this.line = line;
            this.column = column;
        }

        private static Position exact(int line, int column) {
            return new Position(line, column);
        }

        private static Position startOf(Tree tree) {
            SyntaxToken token = tree.firstToken();
            return new Position(token.line(), token.column());
        }

        private static Position endOf(Tree tree) {
            SyntaxToken token = tree.lastToken();
            return new Position(token.line(), token.column() + token.text().length());
        }

        int line() {
            return this.line;
        }

        int column() {
            return this.column;
        }

        @Override
        public int compareTo(Position o) {
            return COMPARATOR.compare(this, o);
        }
    }

    public static class Mapper
    extends SubscriptionVisitor {
        private static final Set<Tree.Kind> KINDS = Stream.of(Type.values()).map(t -> Type.access$400(t)).flatMap(Collection::stream).collect(Collectors.toSet());
        private final Map<Type, Set<JWarning>> warningsByType = new EnumMap<Type, Set<JWarning>>(Type.class);
        private final PriorityQueue<JWarning> warnings = new PriorityQueue<JWarning>(Comparator.comparing(JWarning::start).thenComparing(JWarning::end));

        private Mapper(CompilationUnit ast) {
            Stream.of(ast.getProblems()).map(problem -> Mapper.convert(problem, ast)).filter(Objects::nonNull).forEach(this.warnings::add);
        }

        @CheckForNull
        private static JWarning convert(IProblem problem, CompilationUnit root) {
            for (Type type : Type.values()) {
                if (!type.matches(problem)) continue;
                return new JWarning(problem.getMessage(), type, problem.getSourceLineNumber(), root.getColumnNumber(problem.getSourceStart()), root.getLineNumber(problem.getSourceEnd()), root.getColumnNumber(problem.getSourceEnd()) + 1);
            }
            return null;
        }

        public static Mapper warningsFor(CompilationUnit ast) {
            return new Mapper(ast);
        }

        public void mappedInto(JavaTree.CompilationUnitTreeImpl cut) {
            this.scanTree(cut);
            cut.addWarnings(this.warningsByType);
        }

        @Override
        public List<Tree.Kind> nodesToVisit() {
            return new ArrayList<Tree.Kind>(KINDS);
        }

        @Override
        public void visitNode(Tree tree) {
            if (this.warnings.isEmpty()) {
                return;
            }
            Iterator<JWarning> iterator = this.warnings.iterator();
            while (iterator.hasNext()) {
                JWarning warning = iterator.next();
                if (!Mapper.isInsideTree(warning, tree)) continue;
                Mapper.setSyntaxTree(warning, tree);
                this.warningsByType.computeIfAbsent(warning.type(), k -> new LinkedHashSet()).add(warning);
                if (!Mapper.matchesTreeExactly(warning)) continue;
                iterator.remove();
            }
        }

        @VisibleForTesting
        static void setSyntaxTree(JWarning warning, Tree tree) {
            if (warning.syntaxTree == null || Mapper.isMorePreciseTree(warning.syntaxTree, tree)) {
                warning.syntaxTree = tree;
            }
        }

        @VisibleForTesting
        static boolean isInsideTree(JWarning warning, Tree tree) {
            if (warning.type.kinds.stream().noneMatch(xva$0 -> tree.is((Tree.Kind)((Object)xva$0)))) {
                return false;
            }
            return warning.start().compareTo(Position.startOf(tree)) >= 0 && warning.end().compareTo(Position.endOf(tree)) <= 0;
        }

        @VisibleForTesting
        static boolean isMorePreciseTree(Tree currentTree, Tree newTree) {
            return Position.startOf(newTree).compareTo(Position.startOf(currentTree)) >= 0 && Position.endOf(newTree).compareTo(Position.endOf(currentTree)) <= 0;
        }

        @VisibleForTesting
        static boolean matchesTreeExactly(JWarning warning) {
            Tree syntaxTree = warning.syntaxTree();
            return warning.start().compareTo(Position.startOf(syntaxTree)) == 0 && warning.end().compareTo(Position.endOf(syntaxTree)) == 0;
        }
    }
}

