/*
 * SonarQube Java
 * Copyright (C) 2012-2020 SonarSource SA
 * mailto:info AT sonarsource DOT com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package org.sonar.java.regex.ast;

import java.util.Collections;
import java.util.List;

public class CharacterClassIntersectionTree extends RegexTree {

  private final List<RegexTree> characterClasses;

  private final List<RegexToken> andOperators;

  public CharacterClassIntersectionTree(RegexSource source, IndexRange range, List<RegexTree> characterClasses, List<RegexToken> andOperators) {
    super(source, range);
    this.characterClasses = Collections.unmodifiableList(characterClasses);
    this.andOperators = Collections.unmodifiableList(andOperators);
  }

  public List<RegexTree> getCharacterClasses() {
    return characterClasses;
  }

  public List<RegexToken> getAndOperators() {
    return andOperators;
  }

  @Override
  public void accept(RegexVisitor visitor) {
    visitor.visitCharacterClassIntersection(this);
  }

  @Override
  public Kind kind() {
    return Kind.CHARACTER_CLASS_INTERSECTION;
  }

}
