/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.cfg.CFG;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.Flow;
import org.sonar.java.se.FlowComputation;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4165")
public class RedundantAssignmentsCheck
extends SECheck {
    private static final Set<String> STREAM_TYPES = ImmutableSet.of((Object)"java.util.stream.Stream", (Object)"java.util.stream.IntStream", (Object)"java.util.stream.LongStream", (Object)"java.util.stream.DoubleStream");
    private final Deque<Multimap<AssignmentExpressionTree, AssignmentDataHolder>> assignmentsByMethod = new LinkedList<Multimap<AssignmentExpressionTree, AssignmentDataHolder>>();

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.assignmentsByMethod.clear();
        super.scanFile(context);
    }

    @Override
    public void init(MethodTree methodTree, CFG cfg) {
        this.assignmentsByMethod.push((Multimap<AssignmentExpressionTree, AssignmentDataHolder>)ArrayListMultimap.create());
    }

    @Override
    public ProgramState checkPostStatement(CheckerContext context, Tree syntaxNode) {
        if (syntaxNode.is(Tree.Kind.ASSIGNMENT)) {
            this.handleAssignment(context, (AssignmentExpressionTree)syntaxNode);
        }
        return super.checkPostStatement(context, syntaxNode);
    }

    private void handleAssignment(CheckerContext context, AssignmentExpressionTree assignmentExpressionTree) {
        Symbol assignedSymbol;
        ProgramState.SymbolicValueSymbol assignedVariable;
        block3: {
            block2: {
                assignedVariable = context.getState().peekValueSymbol();
                assignedSymbol = assignedVariable.symbol();
                if (assignedSymbol == null) break block2;
                if (!STREAM_TYPES.stream().anyMatch(assignedSymbol.type()::is)) break block3;
            }
            return;
        }
        ExplodedGraph.Node node = context.getNode();
        ProgramState previousState = node.programState;
        SymbolicValue oldValue = previousState.getValue(assignedSymbol);
        SymbolicValue newValue = assignedVariable.symbolicValue();
        Symbol fromSymbol = previousState.peekValueSymbol().symbol();
        this.assignmentsByMethod.peek().put((Object)assignmentExpressionTree, (Object)new AssignmentDataHolder(assignedSymbol, oldValue, newValue, fromSymbol, node));
    }

    @Override
    public void interruptedExecution(CheckerContext context) {
        this.assignmentsByMethod.pop();
    }

    @Override
    public void checkEndOfExecution(CheckerContext context) {
        for (Map.Entry assignmentForTree : this.assignmentsByMethod.pop().asMap().entrySet()) {
            Collection allAssignments = (Collection)assignmentForTree.getValue();
            if (!allAssignments.stream().allMatch(AssignmentDataHolder::isRedundant)) continue;
            Set<Flow> flows = allAssignments.stream().map(AssignmentDataHolder::flows).flatMap(Collection::stream).collect(Collectors.toSet());
            this.reportIssue((Tree)assignmentForTree.getKey(), String.format("Remove this useless assignment; \"%s\" already holds the assigned value along all execution paths.", ((AssignmentDataHolder)Iterables.getFirst((Iterable)allAssignments, null)).assignedSymbol.name()), flows);
        }
    }

    private static class AssignmentDataHolder {
        private final Symbol assignedSymbol;
        @Nullable
        private final Symbol fromSymbol;
        private final SymbolicValue oldValue;
        private final SymbolicValue newValue;
        private final ExplodedGraph.Node node;

        public AssignmentDataHolder(Symbol assignedSymbol, @Nullable SymbolicValue oldValue, SymbolicValue newValue, @Nullable Symbol fromSymbol, ExplodedGraph.Node node) {
            this.assignedSymbol = assignedSymbol;
            this.fromSymbol = fromSymbol;
            this.oldValue = oldValue;
            this.newValue = newValue;
            this.node = node;
        }

        public boolean isRedundant() {
            return this.oldValue == this.newValue;
        }

        public Set<Flow> flows() {
            return FlowComputation.flow(this.node, this.newValue, Collections.emptyList(), this.fromSymbol, 20);
        }
    }
}

