/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.regex.ast;

import javax.annotation.CheckForNull;
import org.sonar.java.regex.ast.IndexRange;
import org.sonar.java.regex.ast.RegexSource;
import org.sonar.java.regex.ast.RegexSyntaxElement;

public abstract class Quantifier
extends RegexSyntaxElement {
    private final Modifier modifier;

    protected Quantifier(RegexSource source, IndexRange range, Modifier modifier) {
        super(source, range);
        this.modifier = modifier;
    }

    public abstract int getMinimumRepetitions();

    @CheckForNull
    public abstract Integer getMaximumRepetitions();

    public Modifier getModifier() {
        return this.modifier;
    }

    public boolean isOpenEnded() {
        return this.getMaximumRepetitions() == null;
    }

    public abstract boolean isFixed();

    public static enum Modifier {
        GREEDY,
        RELUCTANT,
        POSSESSIVE;

    }
}

