/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.regex.ast;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.regex.ast.IndexRange;
import org.sonar.java.regex.ast.Quantifier;
import org.sonar.java.regex.ast.RegexSource;
import org.sonar.java.regex.ast.RegexToken;

public class CurlyBraceQuantifier
extends Quantifier {
    private final RegexToken minimumRepetitionsToken;
    private final int minimumRepetitions;
    private final RegexToken commaToken;
    private final RegexToken maximumRepetitionsToken;
    private final Integer maximumRepetitions;

    public CurlyBraceQuantifier(RegexSource source, IndexRange range, Quantifier.Modifier modifier, RegexToken minimumRepetitionsToken, @Nullable RegexToken commaToken, @Nullable RegexToken maximumRepetitionsToken) {
        super(source, range, modifier);
        this.minimumRepetitionsToken = minimumRepetitionsToken;
        this.minimumRepetitions = Integer.parseInt(minimumRepetitionsToken.getText());
        this.commaToken = commaToken;
        this.maximumRepetitionsToken = maximumRepetitionsToken;
        this.maximumRepetitions = maximumRepetitionsToken == null ? null : Integer.valueOf(Integer.parseInt(maximumRepetitionsToken.getText()));
    }

    @Override
    public int getMinimumRepetitions() {
        return this.minimumRepetitions;
    }

    @Override
    @CheckForNull
    public Integer getMaximumRepetitions() {
        if (this.commaToken == null) {
            return this.minimumRepetitions;
        }
        return this.maximumRepetitions;
    }

    public RegexToken getMinimumRepetitionsToken() {
        return this.minimumRepetitionsToken;
    }

    public RegexToken getCommaToken() {
        return this.commaToken;
    }

    public RegexToken getMaximumRepetitionsToken() {
        return this.maximumRepetitionsToken;
    }

    @Override
    public boolean isFixed() {
        return this.commaToken == null;
    }
}

