/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.regex.ast;

import javax.annotation.Nullable;
import org.sonar.java.regex.ast.IndexRange;
import org.sonar.java.regex.ast.RegexSource;
import org.sonar.java.regex.ast.RegexTree;
import org.sonar.java.regex.ast.RegexVisitor;

public class BoundaryTree
extends RegexTree {
    private final Type type;

    public BoundaryTree(RegexSource source, Type type, IndexRange range) {
        super(source, range);
        this.type = type;
    }

    @Override
    public void accept(RegexVisitor visitor) {
        visitor.visitBoundary(this);
    }

    @Override
    public RegexTree.Kind kind() {
        return RegexTree.Kind.BOUNDARY;
    }

    public Type type() {
        return this.type;
    }

    public static enum Type {
        LINE_START('^'),
        LINE_END('$'),
        WORD('b'),
        UNICODE_EXTENDED_GRAPHEME_CLUSTER('b'),
        NON_WORD('B'),
        INPUT_START('A'),
        PREVIOUS_MATCH_END('G'),
        INPUT_END_FINAL_TERMINATOR('Z'),
        INPUT_END('z');

        private final char key;

        private Type(char key) {
            this.key = key;
        }

        @Nullable
        public static Type forKey(char k) {
            for (Type type : Type.values()) {
                if (type.key != k) continue;
                return type;
            }
            return null;
        }
    }
}

