/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.regex;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.java.AnalyzerMessage;
import org.sonar.java.regex.ast.Location;
import org.sonar.java.regex.ast.RegexSyntaxElement;
import org.sonar.plugins.java.api.JavaCheck;

public interface RegexCheck
extends JavaCheck {

    public static class RegexIssueLocation {
        private final List<AnalyzerMessage.TextSpan> locations;
        private final String message;

        public RegexIssueLocation(RegexSyntaxElement tree, String message) {
            this.locations = RegexIssueLocation.textSpansFromRegexSyntaxElement(tree);
            this.message = message;
        }

        public RegexIssueLocation(RegexSyntaxElement start, RegexSyntaxElement end, String message) {
            this.locations = RegexIssueLocation.textSpansBetweenRegexSyntaxElement(start, end);
            this.message = message;
        }

        private RegexIssueLocation(AnalyzerMessage.TextSpan location, String message) {
            this.locations = Collections.singletonList(location);
            this.message = message;
        }

        public List<AnalyzerMessage.TextSpan> locations() {
            return this.locations;
        }

        public String message() {
            return this.message;
        }

        public List<RegexIssueLocation> toSingleLocationItems() {
            if (this.locations.size() == 1) {
                return Collections.singletonList(this);
            }
            return this.locations.stream().map(loc -> new RegexIssueLocation((AnalyzerMessage.TextSpan)loc, this.message)).collect(Collectors.toList());
        }

        private static List<AnalyzerMessage.TextSpan> textSpansBetweenRegexSyntaxElement(RegexSyntaxElement start, RegexSyntaxElement end) {
            Location startLocation = start.getLocations().get(0);
            AnalyzerMessage.TextSpan startSpan = AnalyzerMessage.textSpanFor(startLocation.getJavaTree());
            Location endLocation = end.getLocations().get(0);
            AnalyzerMessage.TextSpan endSpan = AnalyzerMessage.textSpanFor(endLocation.getJavaTree());
            return Collections.singletonList(new AnalyzerMessage.TextSpan(startSpan.startLine, startSpan.startCharacter + startLocation.getBeginningOffset() + 1, endSpan.endLine, endSpan.startCharacter + endLocation.getEndingOffset() + 1));
        }

        private static List<AnalyzerMessage.TextSpan> textSpansFromRegexSyntaxElement(RegexSyntaxElement tree) {
            List<Object> locs = tree.getLocations().stream().filter(location -> !location.isEmpty()).collect(Collectors.toList());
            if (locs.isEmpty()) {
                locs = Collections.singletonList(tree.getLocations().get(0));
            }
            return locs.stream().map(location -> {
                AnalyzerMessage.TextSpan result = AnalyzerMessage.textSpanFor(location.getJavaTree());
                return new AnalyzerMessage.TextSpan(result.startLine, result.startCharacter + location.getBeginningOffset() + 1, result.endLine, result.startCharacter + location.getEndingOffset() + 1 + (location.isEmpty() ? 1 : 0));
            }).collect(Collectors.toList());
        }
    }
}

