/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.regex;

import javax.annotation.CheckForNull;
import org.sonar.java.regex.ast.IndexRange;
import org.sonar.java.regex.ast.JavaCharacter;
import org.sonar.java.regex.ast.RegexSource;

public class JavaUnicodeEscapeParser {
    private final RegexSource source;
    private final String sourceText;
    private final int textLength;
    private int index;
    private JavaCharacter current;
    private boolean isEscaping = false;

    public JavaUnicodeEscapeParser(RegexSource source) {
        this.source = source;
        this.sourceText = source.getSourceText();
        this.textLength = this.sourceText.length();
        this.index = 0;
        this.moveNext();
    }

    public void resetTo(int index) {
        this.index = index;
        this.moveNext();
    }

    @CheckForNull
    public JavaCharacter getCurrent() {
        return this.current;
    }

    public void moveNext() {
        char ch;
        boolean isEscapedUnicode;
        if (this.index >= this.textLength) {
            this.current = null;
            return;
        }
        int startIndex = this.index;
        boolean isBackslash = this.sourceText.charAt(this.index) == '\\';
        boolean bl = isEscapedUnicode = isBackslash && this.index < this.textLength - 1 && this.sourceText.charAt(this.index + 1) == 'u';
        if (isEscapedUnicode && !this.isEscaping) {
            this.index += 2;
            while (this.sourceText.charAt(this.index) == 'u') {
                ++this.index;
            }
            StringBuilder codePoint = new StringBuilder(4);
            int i = 0;
            while (i < 4 && this.index < this.textLength) {
                codePoint.append(this.sourceText.charAt(this.index));
                ++i;
                ++this.index;
            }
            ch = (char)Integer.parseInt(codePoint.toString(), 16);
        } else {
            ch = this.sourceText.charAt(this.index);
            ++this.index;
            this.isEscaping = isBackslash && !this.isEscaping;
        }
        this.current = new JavaCharacter(this.source, new IndexRange(startIndex, this.index), ch, isEscapedUnicode);
    }
}

