/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import com.google.common.collect.Lists;
import java.util.Objects;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.expression.AssessableExpressionTree;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class BinaryExpressionTreeImpl
extends AssessableExpressionTree
implements BinaryExpressionTree {
    private final Tree.Kind kind;
    private final ExpressionTree leftOperand;
    private final InternalSyntaxToken operator;
    private final ExpressionTree rightOperand;

    public BinaryExpressionTreeImpl(Tree.Kind kind, ExpressionTree leftOperand, InternalSyntaxToken operator, ExpressionTree rightOperand) {
        this.kind = Objects.requireNonNull(kind);
        this.leftOperand = Objects.requireNonNull(leftOperand);
        this.operator = operator;
        this.rightOperand = Objects.requireNonNull(rightOperand);
    }

    @Override
    public ExpressionTree leftOperand() {
        return this.leftOperand;
    }

    @Override
    public SyntaxToken operatorToken() {
        return this.operator;
    }

    @Override
    public ExpressionTree rightOperand() {
        return this.rightOperand;
    }

    @Override
    public Tree.Kind kind() {
        return this.kind;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitBinaryExpression(this);
    }

    @Override
    public Iterable<Tree> children() {
        return Lists.newArrayList((Object[])new Tree[]{this.leftOperand, this.operator, this.rightOperand});
    }
}

