/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.java.AnalyzerMessage;
import org.sonar.java.SonarComponents;
import org.sonar.java.model.DefaultJavaFileScannerContext;
import org.sonar.java.model.Sema;
import org.sonar.java.model.VisitorsBridge;
import org.sonar.java.se.SymbolicExecutionMode;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.Tree;

public class VisitorsBridgeForTests
extends VisitorsBridge {
    private TestJavaFileScannerContext testContext;
    private boolean enableSemantic = true;

    @VisibleForTesting
    public VisitorsBridgeForTests(JavaFileScanner visitor, SonarComponents sonarComponents) {
        this(Collections.singletonList(visitor), new ArrayList<File>(), sonarComponents);
    }

    public VisitorsBridgeForTests(Iterable<? extends JavaCheck> visitors, @Nullable SonarComponents sonarComponents) {
        super(visitors, new ArrayList<File>(), sonarComponents, SymbolicExecutionMode.DISABLED);
        this.enableSemantic = false;
    }

    public VisitorsBridgeForTests(Iterable<? extends JavaCheck> visitors, List<File> projectClasspath, @Nullable SonarComponents sonarComponents) {
        super(visitors, projectClasspath, sonarComponents, SymbolicExecutionMode.getMode((JavaCheck[])Iterables.toArray(visitors, JavaCheck.class)));
    }

    @Override
    protected JavaFileScannerContext createScannerContext(CompilationUnitTree tree, Sema semanticModel, SonarComponents sonarComponents, boolean failedParsing) {
        Sema model = this.enableSemantic ? semanticModel : null;
        this.testContext = new TestJavaFileScannerContext(tree, this.currentFile, model, sonarComponents, this.javaVersion, failedParsing);
        return this.testContext;
    }

    public TestJavaFileScannerContext lastCreatedTestContext() {
        return this.testContext;
    }

    public static class TestJavaFileScannerContext
    extends DefaultJavaFileScannerContext {
        private final Set<AnalyzerMessage> issues = new HashSet<AnalyzerMessage>();
        private final SonarComponents sonarComponents;

        public TestJavaFileScannerContext(CompilationUnitTree tree, InputFile inputFile, Sema semanticModel, @Nullable SonarComponents sonarComponents, JavaVersion javaVersion, boolean failedParsing) {
            super(tree, inputFile, semanticModel, sonarComponents, javaVersion, failedParsing);
            this.sonarComponents = sonarComponents;
        }

        public Set<AnalyzerMessage> getIssues() {
            return this.issues;
        }

        @Override
        public void addIssueOnProject(JavaCheck javaCheck, String message) {
            this.issues.add(new AnalyzerMessage(javaCheck, this.sonarComponents.project(), null, message, 0));
        }

        @Override
        public void addIssue(int line, JavaCheck javaCheck, String message, @Nullable Integer cost) {
            this.issues.add(new AnalyzerMessage(javaCheck, (InputComponent)this.getInputFile(), line, message, cost != null ? cost : 0));
        }

        @Override
        public void reportIssue(JavaCheck javaCheck, Tree syntaxNode, String message, List<JavaFileScannerContext.Location> secondary, @Nullable Integer cost) {
            List<List<JavaFileScannerContext.Location>> flows = secondary.stream().map(Collections::singletonList).collect(Collectors.toList());
            this.issues.add(TestJavaFileScannerContext.createAnalyzerMessage(this.getInputFile(), javaCheck, syntaxNode, null, message, flows, cost));
        }

        @Override
        public void reportIssue(JavaCheck javaCheck, Tree startTree, Tree endTree, String message) {
            this.issues.add(this.createAnalyzerMessage(javaCheck, startTree, endTree, message, Collections.emptyList(), null));
        }

        @Override
        public void reportIssue(JavaCheck javaCheck, Tree startTree, Tree endTree, String message, List<JavaFileScannerContext.Location> secondary, @Nullable Integer cost) {
            this.issues.add(this.createAnalyzerMessage(javaCheck, startTree, endTree, message, secondary, cost));
        }

        @Override
        public void reportIssueWithFlow(JavaCheck javaCheck, Tree syntaxNode, String message, Iterable<List<JavaFileScannerContext.Location>> flows, @Nullable Integer cost) {
            this.issues.add(TestJavaFileScannerContext.createAnalyzerMessage(this.getInputFile(), javaCheck, syntaxNode, null, message, flows, cost));
        }

        @Override
        public void reportIssue(AnalyzerMessage message) {
            this.issues.add(message);
        }

        @Override
        public AnalyzerMessage createAnalyzerMessage(JavaCheck javaCheck, Tree startTree, String message) {
            return TestJavaFileScannerContext.createAnalyzerMessage(this.getInputFile(), javaCheck, startTree, null, message, Arrays.asList(new List[0]), null);
        }

        private AnalyzerMessage createAnalyzerMessage(JavaCheck javaCheck, Tree startTree, @Nullable Tree endTree, String message, List<JavaFileScannerContext.Location> secondary, @Nullable Integer cost) {
            List<List<JavaFileScannerContext.Location>> flows = secondary.stream().map(Collections::singletonList).collect(Collectors.toList());
            return TestJavaFileScannerContext.createAnalyzerMessage(this.getInputFile(), javaCheck, startTree, endTree, message, flows, cost);
        }
    }
}

