/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.symbolicvalues;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.semantic.Symbol;

public abstract class BinarySymbolicValue
extends SymbolicValue {
    SymbolicValue leftOp;
    @Nullable
    Symbol leftSymbol;
    SymbolicValue rightOp;
    @Nullable
    Symbol rightSymbol;

    @Override
    public boolean references(SymbolicValue other) {
        return this.leftOp.equals(other) || this.rightOp.equals(other) || this.leftOp.references(other) || this.rightOp.references(other);
    }

    @Override
    public void computedFrom(List<ProgramState.SymbolicValueSymbol> symbolicValues) {
        Preconditions.checkArgument((symbolicValues.size() == 2 ? 1 : 0) != 0);
        Preconditions.checkState((this.leftOp == null && this.rightOp == null ? 1 : 0) != 0, (Object)"Operands already set!");
        this.rightOp = symbolicValues.get(0).symbolicValue();
        this.rightSymbol = symbolicValues.get(0).symbol();
        this.leftOp = symbolicValues.get(1).symbolicValue();
        this.leftSymbol = symbolicValues.get(1).symbol();
    }

    @Override
    public List<Symbol> computedFromSymbols() {
        ArrayList<Symbol> result = new ArrayList<Symbol>();
        if (this.leftSymbol == null) {
            result.addAll(this.leftOp.computedFromSymbols());
        } else {
            result.add(this.leftSymbol);
        }
        if (this.rightSymbol == null) {
            result.addAll(this.rightOp.computedFromSymbols());
        } else {
            result.add(this.rightSymbol);
        }
        return result;
    }

    @CheckForNull
    public Symbol leftSymbol() {
        return this.leftSymbol;
    }

    @CheckForNull
    public Symbol rightSymbol() {
        return this.rightSymbol;
    }

    @Override
    public List<SymbolicValue> computedFrom() {
        return ImmutableList.of((Object)this.leftOp, (Object)this.rightOp);
    }

    public SymbolicValue getLeftOp() {
        return this.leftOp;
    }

    public SymbolicValue getRightOp() {
        return this.rightOp;
    }
}

