/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.CheckerTreeNodeVisitor;
import org.sonar.java.se.checks.ExceptionalYieldChecker;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.constraint.BooleanConstraint;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3655")
public class OptionalGetBeforeIsPresentCheck
extends SECheck {
    private static final ExceptionalYieldChecker EXCEPTIONAL_YIELD_CHECKER = new ExceptionalYieldChecker("\"NoSuchElementException\" will be thrown when invoking method \"%s()\" without verifying Optional parameter.");
    private static final MethodMatcher OPTIONAL_GET = OptionalGetBeforeIsPresentCheck.optionalMethod("get").withoutParameter();
    private static final MethodMatcher OPTIONAL_ORELSE = OptionalGetBeforeIsPresentCheck.optionalMethod("orElse").withAnyParameters();
    private static final MethodMatcherCollection OPTIONAL_TEST_METHODS = MethodMatcherCollection.create(OptionalGetBeforeIsPresentCheck.optionalMethod("isPresent").withoutParameter(), OptionalGetBeforeIsPresentCheck.optionalMethod("isEmpty").withoutParameter());
    private static final MethodMatcher OPTIONAL_EMPTY = OptionalGetBeforeIsPresentCheck.optionalMethod("empty").withoutParameter();
    private static final MethodMatcher OPTIONAL_OF = OptionalGetBeforeIsPresentCheck.optionalMethod("of").withAnyParameters();
    private static final MethodMatcher OPTIONAL_OF_NULLABLE = OptionalGetBeforeIsPresentCheck.optionalMethod("ofNullable").withAnyParameters();
    private static final MethodMatcher OPTIONAL_FILTER = OptionalGetBeforeIsPresentCheck.optionalMethod("filter").withAnyParameters();

    private static MethodMatcher optionalMethod(String methodName) {
        return MethodMatcher.create().typeDefinition("java.util.Optional").name(methodName);
    }

    @Override
    public ProgramState checkPreStatement(CheckerContext context, Tree syntaxNode) {
        PreStatementVisitor visitor = new PreStatementVisitor(this, context);
        syntaxNode.accept(visitor);
        return visitor.programState;
    }

    @Override
    public ProgramState checkPostStatement(CheckerContext context, Tree syntaxNode) {
        List<ProgramState> programStates = OptionalGetBeforeIsPresentCheck.setOptionalConstraint(context, syntaxNode);
        Preconditions.checkState((programStates.size() == 1 ? 1 : 0) != 0);
        return programStates.get(0);
    }

    private static List<ProgramState> setOptionalConstraint(CheckerContext context, Tree syntaxNode) {
        SymbolicValue paramSV;
        ProgramState psPriorMethodInvocation;
        ObjectConstraint paramConstraint;
        ProgramState programState = context.getState();
        if (!syntaxNode.is(Tree.Kind.METHOD_INVOCATION)) {
            return Collections.singletonList(programState);
        }
        MethodInvocationTree mit = (MethodInvocationTree)syntaxNode;
        SymbolicValue peekValue = programState.peekValue();
        Objects.requireNonNull(peekValue);
        if (OPTIONAL_EMPTY.matches(mit)) {
            return peekValue.setConstraint(programState, OptionalConstraint.NOT_PRESENT);
        }
        if (OPTIONAL_OF.matches(mit)) {
            return peekValue.setConstraint(programState, OptionalConstraint.PRESENT);
        }
        if (OPTIONAL_OF_NULLABLE.matches(mit) && (paramConstraint = (psPriorMethodInvocation = context.getNode().programState).getConstraint(paramSV = psPriorMethodInvocation.peekValue(0), ObjectConstraint.class)) != null) {
            return peekValue.setConstraint(programState, paramConstraint == ObjectConstraint.NULL ? OptionalConstraint.NOT_PRESENT : OptionalConstraint.PRESENT);
        }
        return Collections.singletonList(programState);
    }

    @Override
    public void checkEndOfExecutionPath(CheckerContext context, ConstraintManager constraintManager) {
        EXCEPTIONAL_YIELD_CHECKER.reportOnExceptionalYield(context.getNode(), this);
    }

    private static class PreStatementVisitor
    extends CheckerTreeNodeVisitor {
        private final CheckerContext context;
        private final ConstraintManager constraintManager;
        private final SECheck check;

        private PreStatementVisitor(SECheck check, CheckerContext context) {
            super(context.getState());
            this.context = context;
            this.constraintManager = context.getConstraintManager();
            this.check = check;
        }

        @Override
        public void visitMethodInvocation(MethodInvocationTree tree) {
            SymbolicValue peek = this.programState.peekValue();
            if (OPTIONAL_TEST_METHODS.anyMatch(tree)) {
                this.constraintManager.setValueFactory(() -> new OptionalTestMethodSymbolicValue(peek, tree.symbol()));
            } else if (OPTIONAL_GET.matches(tree) && this.presenceHasNotBeenChecked(peek)) {
                this.context.addExceptionalYield(peek, this.programState, "java.util.NoSuchElementException", this.check);
                this.reportIssue(tree);
                this.programState = this.programState.addConstraint(peek, OptionalConstraint.PRESENT);
            } else if (OPTIONAL_FILTER.matches(tree)) {
                SymbolicValue optionalSV = this.programState.peekValue(1);
                if (this.programState.getConstraint(optionalSV, OptionalConstraint.class) == OptionalConstraint.NOT_PRESENT) {
                    this.constraintManager.setValueFactory(() -> optionalSV);
                } else {
                    this.constraintManager.setValueFactory(() -> new FilteredOptionalSymbolicValue(optionalSV));
                }
            } else if (OPTIONAL_ORELSE.matches(tree)) {
                ProgramState.Pop pop = this.programState.unstackValue(2);
                SymbolicValue orElseValue = pop.values.get(0);
                SymbolicValue optional = pop.values.get(1);
                List<ProgramState> psEmpty = optional.setConstraint(pop.state.stackValue(orElseValue), OptionalConstraint.NOT_PRESENT);
                SymbolicValue symbolicValue = optional instanceof OptionalSymbolicValue ? ((OptionalSymbolicValue)optional).wrappedValue : this.constraintManager.createSymbolicValue(tree);
                List<ProgramState> psPresent = optional.setConstraint(pop.state.stackValue(symbolicValue), OptionalConstraint.PRESENT);
                psEmpty.forEach(this.context::addTransition);
                psPresent.forEach(this.context::addTransition);
                this.programState = null;
            } else if (OPTIONAL_OF.matches(tree) || OPTIONAL_OF_NULLABLE.matches(tree)) {
                this.constraintManager.setValueFactory(() -> new OptionalSymbolicValue(peek));
            }
        }

        private void reportIssue(MethodInvocationTree mit) {
            String identifier = PreStatementVisitor.getIdentifierPart(mit.methodSelect());
            String issueMsg = identifier.isEmpty() ? "Optional#" : identifier + ".";
            MethodInvocationTree reportTree = mit.methodSelect().is(Tree.Kind.MEMBER_SELECT) ? ((MemberSelectExpressionTree)mit.methodSelect()).expression() : mit;
            this.context.reportIssue(reportTree, this.check, "Call \"" + issueMsg + "isPresent()\" before accessing the value.");
        }

        private boolean presenceHasNotBeenChecked(SymbolicValue sv) {
            return this.programState.getConstraint(sv, OptionalConstraint.class) != OptionalConstraint.PRESENT;
        }

        private static String getIdentifierPart(ExpressionTree methodSelect) {
            if (methodSelect.is(Tree.Kind.MEMBER_SELECT)) {
                ExpressionTree expression = ((MemberSelectExpressionTree)methodSelect).expression();
                if (expression.is(Tree.Kind.IDENTIFIER)) {
                    return ((IdentifierTree)expression).name();
                }
            }
            return "";
        }
    }

    private static class OptionalTestMethodSymbolicValue
    extends SymbolicValue {
        private final SymbolicValue optionalSV;
        private final boolean isIsEmpty;

        public OptionalTestMethodSymbolicValue(SymbolicValue sv, Symbol testMethod) {
            this.optionalSV = sv;
            this.isIsEmpty = "isEmpty".equals(testMethod.name());
        }

        @Override
        public List<ProgramState> setConstraint(ProgramState programState, BooleanConstraint booleanConstraint) {
            OptionalConstraint optionalConstraint = programState.getConstraint(this.optionalSV, OptionalConstraint.class);
            if (this.isImpossibleState(booleanConstraint, optionalConstraint)) {
                return Collections.emptyList();
            }
            if (optionalConstraint == OptionalConstraint.NOT_PRESENT || optionalConstraint == OptionalConstraint.PRESENT) {
                return Collections.singletonList(programState);
            }
            return this.optionalSV.setConstraint(programState, this.expectedOptionalConstraint(booleanConstraint));
        }

        private boolean isImpossibleState(BooleanConstraint booleanConstraint, @Nullable OptionalConstraint optionalConstraint) {
            return optionalConstraint == this.expectedOptionalConstraint(booleanConstraint.isTrue() ? BooleanConstraint.FALSE : BooleanConstraint.TRUE);
        }

        private OptionalConstraint expectedOptionalConstraint(BooleanConstraint booleanConstraint) {
            if (booleanConstraint.isTrue()) {
                return this.isIsEmpty ? OptionalConstraint.NOT_PRESENT : OptionalConstraint.PRESENT;
            }
            return this.isIsEmpty ? OptionalConstraint.PRESENT : OptionalConstraint.NOT_PRESENT;
        }

        @Override
        public boolean references(SymbolicValue other) {
            return this.optionalSV.equals(other) || this.optionalSV.references(other);
        }
    }

    private static class FilteredOptionalSymbolicValue
    extends OptionalSymbolicValue {
        private FilteredOptionalSymbolicValue(SymbolicValue wrappedValue) {
            super(wrappedValue);
        }

        @Override
        public List<ProgramState> setConstraint(ProgramState programState, Constraint constraint) {
            ProgramState ps = programState;
            if (constraint == OptionalConstraint.PRESENT) {
                List<ProgramState> programStates = this.wrappedValue.setConstraint(ps, constraint);
                Preconditions.checkState((programStates.size() == 1 ? 1 : 0) != 0);
                ps = programStates.get(0);
            }
            return super.setConstraint(ps, constraint);
        }
    }

    private static class OptionalSymbolicValue
    extends SymbolicValue {
        protected final SymbolicValue wrappedValue;

        private OptionalSymbolicValue(SymbolicValue wrappedValue) {
            this.wrappedValue = wrappedValue;
        }

        @Override
        public boolean references(SymbolicValue other) {
            return this.wrappedValue.equals(other) || this.wrappedValue.references(other);
        }
    }

    private static enum OptionalConstraint implements Constraint
    {
        PRESENT,
        NOT_PRESENT;


        @Override
        public boolean isValidWith(@Nullable Constraint constraint) {
            return constraint == null || this == constraint;
        }

        @Override
        public boolean hasPreciseValue() {
            return this == NOT_PRESENT;
        }
    }
}

