/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.JavaType;
import org.sonar.plugins.java.api.semantic.Type;

public class WildCardType
extends JavaType {
    final JavaType bound;
    final BoundType boundType;

    public WildCardType(JavaType bound, BoundType boundType) {
        super(16, new JavaSymbol.WildcardSymbol(boundType == BoundType.UNBOUNDED ? boundType.toString() : (Object)((Object)boundType) + bound.symbol.name()));
        this.bound = bound;
        this.boundType = boundType;
        this.symbol.type = this;
    }

    @Override
    public boolean isSubtypeOf(String fullyQualifiedName) {
        return "java.lang.Object".equals(fullyQualifiedName) || this.boundType == BoundType.EXTENDS && this.bound.isSubtypeOf(fullyQualifiedName);
    }

    @Override
    public boolean isSubtypeOf(Type superType) {
        if (((JavaType)superType).isTagged(16)) {
            WildCardType superTypeWildcard = (WildCardType)superType;
            JavaType superTypeBound = superTypeWildcard.bound;
            switch (superTypeWildcard.boundType) {
                case UNBOUNDED: {
                    return true;
                }
                case SUPER: {
                    return this.boundType == BoundType.SUPER && superTypeBound.isSubtypeOf(this.bound);
                }
                case EXTENDS: {
                    return this.boundType != BoundType.SUPER && this.bound.isSubtypeOf(superTypeBound);
                }
            }
        }
        return "java.lang.Object".equals(superType.fullyQualifiedName()) || this.boundType == BoundType.EXTENDS && this.bound.isSubtypeOf(superType);
    }

    public boolean isSubtypeOfBound(JavaType type) {
        switch (this.boundType) {
            case SUPER: {
                return this.bound.isSubtypeOf(type);
            }
            case EXTENDS: {
                return !this.boundIsTypeVarAndNotType(type) && type.isSubtypeOf(this.bound);
            }
        }
        return true;
    }

    private boolean boundIsTypeVarAndNotType(JavaType type) {
        return this.bound.isTagged(15) && !type.isTagged(15);
    }

    public static enum BoundType {
        UNBOUNDED("?"),
        SUPER("? super "),
        EXTENDS("? extends ");

        private final String name;

        private BoundType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

