/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.declaration.VariableTreeImpl;
import org.sonar.java.resolve.ClassJavaType;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.JavaType;
import org.sonar.java.resolve.MethodJavaType;
import org.sonar.java.resolve.ParametrizedTypeCache;
import org.sonar.java.resolve.Resolve;
import org.sonar.java.resolve.Scope;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.resolve.Symbols;
import org.sonar.java.resolve.TypeAndReferenceSolver;
import org.sonar.java.resolve.TypeSubstitution;
import org.sonar.java.resolve.TypeVariableJavaType;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeParameterTree;
import org.sonar.plugins.java.api.tree.TypeParameters;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class SecondPass
implements JavaSymbol.Completer {
    private static final String CONSTRUCTOR_NAME = "<init>";
    private final SemanticModel semanticModel;
    private final Symbols symbols;
    private final TypeAndReferenceSolver typeAndReferenceSolver;
    private final ParametrizedTypeCache parametrizedTypeCache;

    public SecondPass(SemanticModel semanticModel, Symbols symbols, ParametrizedTypeCache parametrizedTypeCache, TypeAndReferenceSolver typeAndReferenceSolver) {
        this.semanticModel = semanticModel;
        this.symbols = symbols;
        this.parametrizedTypeCache = parametrizedTypeCache;
        this.typeAndReferenceSolver = typeAndReferenceSolver;
    }

    @Override
    public void complete(JavaSymbol symbol) {
        if (symbol.kind == 2) {
            this.complete((JavaSymbol.TypeJavaSymbol)symbol);
        } else if (symbol.kind == 16) {
            this.complete((JavaSymbol.MethodJavaSymbol)symbol);
        } else if (symbol.kind == 4) {
            this.complete((JavaSymbol.VariableJavaSymbol)symbol);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void complete(JavaSymbol.TypeJavaSymbol symbol) {
        Resolve.Env env = this.semanticModel.getEnv(symbol);
        ClassJavaType type = (ClassJavaType)symbol.type;
        if (!symbol.isFlag(8192)) {
            symbol.members.enter(new JavaSymbol.VariableJavaSymbol(16, "this", symbol.type, (JavaSymbol)symbol));
        }
        if ("".equals(symbol.name)) {
            type.interfaces = Collections.emptyList();
            return;
        }
        ClassTree tree = symbol.declaration;
        this.completeTypeParameters(tree.typeParameters(), env);
        ImmutableList.Builder interfaces = ImmutableList.builder();
        tree.superInterfaces().stream().map(interfaceTree -> this.resolveType(env, (Tree)interfaceTree)).filter(Objects::nonNull).forEach(arg_0 -> ((ImmutableList.Builder)interfaces).add(arg_0));
        if (tree.is(Tree.Kind.ANNOTATION_TYPE)) {
            interfaces.add((Object)this.symbols.annotationType);
        }
        if (tree.is(Tree.Kind.ENUM, Tree.Kind.INTERFACE) && symbol.owner.isKind(2)) {
            symbol.flags |= 8;
        }
        type.interfaces = interfaces.build();
        this.populateSuperclass(symbol, env, type);
        if ((symbol.flags() & 0x200) == 0) {
            symbol.members.enter(new JavaSymbol.VariableJavaSymbol(16, "super", type.supertype, (JavaSymbol)symbol));
        } else {
            symbol.members.enter(new JavaSymbol.VariableJavaSymbol(16, "super", type, (JavaSymbol)symbol));
        }
        if (tree.is(Tree.Kind.CLASS, Tree.Kind.ENUM) && symbol.lookupSymbols(CONSTRUCTOR_NAME).isEmpty()) {
            Symbol owner;
            List<JavaType> argTypes = Collections.emptyList();
            if (!symbol.isStatic() && !((JavaSymbol)(owner = symbol.owner())).isPackageSymbol()) {
                argTypes = Collections.singletonList(Objects.requireNonNull(((JavaSymbol)owner).enclosingClass().type));
            }
            JavaSymbol.MethodJavaSymbol defaultConstructor = new JavaSymbol.MethodJavaSymbol(symbol.flags & 7, CONSTRUCTOR_NAME, symbol);
            MethodJavaType defaultConstructorType = new MethodJavaType(argTypes, null, Collections.emptyList(), symbol);
            defaultConstructor.setMethodType(defaultConstructorType);
            defaultConstructor.parameters = new Scope(defaultConstructor);
            symbol.members.enter(defaultConstructor);
        }
    }

    private void populateSuperclass(JavaSymbol.TypeJavaSymbol symbol, Resolve.Env env, ClassJavaType type) {
        ClassTree tree = symbol.declaration;
        TypeTree superClassTree = tree.superClass();
        if (superClassTree != null) {
            type.supertype = this.resolveType(env, superClassTree);
            SecondPass.checkHierarchyCycles(symbol.type);
        } else if (tree.is(Tree.Kind.ENUM)) {
            Scope enumParameters = ((JavaSymbol.TypeJavaSymbol)this.symbols.enumType.symbol()).typeParameters();
            TypeVariableJavaType enumParameter = (TypeVariableJavaType)enumParameters.lookup("E").get(0).type();
            type.supertype = this.parametrizedTypeCache.getParametrizedTypeType(this.symbols.enumType.symbol, new TypeSubstitution().add(enumParameter, type));
        } else if (tree.is(Tree.Kind.CLASS, Tree.Kind.INTERFACE)) {
            type.supertype = this.symbols.objectType;
        }
    }

    private void completeTypeParameters(TypeParameters typeParameters, Resolve.Env env) {
        for (TypeParameterTree typeParameterTree : typeParameters) {
            ArrayList<JavaType> bounds = new ArrayList<JavaType>();
            if (typeParameterTree.bounds().isEmpty()) {
                bounds.add(this.symbols.objectType);
            } else {
                for (Tree boundTree : typeParameterTree.bounds()) {
                    bounds.add(this.resolveType(env, boundTree));
                }
            }
            ((TypeVariableJavaType)this.semanticModel.getSymbol((Tree)typeParameterTree).type()).bounds = bounds;
        }
    }

    private static void checkHierarchyCycles(JavaType baseType) {
        HashSet<ClassJavaType> types = new HashSet<ClassJavaType>();
        ClassJavaType type = (ClassJavaType)baseType;
        while (type != null) {
            if (!types.add(type)) {
                throw new IllegalStateException("Cycling class hierarchy detected with symbol : " + baseType.symbol.name + ".");
            }
            type = (ClassJavaType)type.symbol.getSuperclass();
        }
    }

    private void complete(JavaSymbol.MethodJavaSymbol symbol) {
        Symbol owner;
        MethodTree methodTree = symbol.declaration;
        Resolve.Env env = this.semanticModel.getEnv(symbol);
        this.completeTypeParameters(methodTree.typeParameters(), env);
        ImmutableList.Builder thrownTypes = ImmutableList.builder();
        for (TypeTree throwClause : methodTree.throwsClauses()) {
            JavaType thrownType = this.resolveType(env, throwClause);
            if (thrownType == null) continue;
            thrownTypes.add((Object)thrownType);
        }
        JavaType returnType = null;
        ArrayList<JavaType> argTypes = new ArrayList<JavaType>();
        if (!CONSTRUCTOR_NAME.equals(symbol.name)) {
            returnType = this.resolveType(env, methodTree.returnType());
            if (returnType != null) {
                symbol.returnType = returnType.symbol;
            }
        } else if (!((JavaSymbol)((Object)symbol.enclosingClass())).isStatic() && !((JavaSymbol)(owner = ((JavaSymbol.TypeJavaSymbol)symbol.enclosingClass()).owner())).isPackageSymbol()) {
            argTypes.add(((JavaSymbol)owner).enclosingClass().type);
        }
        List<VariableTree> parametersTree = methodTree.parameters();
        List<JavaSymbol> scopeSymbols = symbol.parameters.scopeSymbols();
        for (int i = 0; i < parametersTree.size(); ++i) {
            VariableTree variableTree = parametersTree.get(i);
            JavaSymbol param = scopeSymbols.get(i);
            if (variableTree.simpleName().name().equals(param.getName())) {
                param.complete();
                argTypes.add(param.getType());
            }
            if (!((VariableTreeImpl)variableTree).isVararg()) continue;
            symbol.flags |= 0x80;
        }
        MethodJavaType methodType = new MethodJavaType(argTypes, returnType, (List<JavaType>)thrownTypes.build(), (JavaSymbol.TypeJavaSymbol)symbol.owner);
        symbol.setMethodType(methodType);
    }

    private void complete(JavaSymbol.VariableJavaSymbol symbol) {
        VariableTree variableTree = symbol.declaration;
        Resolve.Env env = this.semanticModel.getEnv(symbol);
        symbol.type = variableTree.is(Tree.Kind.ENUM_CONSTANT) ? env.enclosingClass.type : this.resolveType(env, variableTree.type());
    }

    private JavaType resolveType(Resolve.Env env, Tree tree) {
        Preconditions.checkArgument((boolean)SecondPass.checkTypeOfTree(tree), (Object)("Kind of tree unexpected " + (Object)((Object)tree.kind())));
        if (((AbstractTypedTree)tree).isTypeSet()) {
            return (JavaType)((AbstractTypedTree)tree).symbolType();
        }
        this.typeAndReferenceSolver.env = env;
        this.typeAndReferenceSolver.resolveAs(tree, 2, env);
        this.typeAndReferenceSolver.env = null;
        return (JavaType)((AbstractTypedTree)tree).symbolType();
    }

    private static boolean checkTypeOfTree(Tree tree) {
        return tree.is(Tree.Kind.MEMBER_SELECT, Tree.Kind.IDENTIFIER, Tree.Kind.PARAMETERIZED_TYPE, Tree.Kind.ARRAY_TYPE, Tree.Kind.UNION_TYPE, Tree.Kind.PRIMITIVE_TYPE, Tree.Kind.VAR_TYPE, Tree.Kind.INFERED_TYPE);
    }
}

