/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.model.LiteralUtils;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.java.model.declaration.ClassTreeImpl;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.java.model.declaration.VariableTreeImpl;
import org.sonar.java.resolve.ArrayJavaType;
import org.sonar.java.resolve.Flags;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.MethodJavaType;
import org.sonar.java.resolve.ParametrizedTypeCache;
import org.sonar.java.resolve.Resolve;
import org.sonar.java.resolve.Scope;
import org.sonar.java.resolve.SecondPass;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.resolve.Symbols;
import org.sonar.java.resolve.TypeAndReferenceSolver;
import org.sonar.java.resolve.TypeSubstitution;
import org.sonar.java.resolve.TypeVariableJavaType;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.EnumConstantTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ImportClauseTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifierKeywordTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.PackageDeclarationTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.TypeParameterTree;
import org.sonar.plugins.java.api.tree.TypeParameters;
import org.sonar.plugins.java.api.tree.VariableTree;

public class FirstPass
extends BaseTreeVisitor {
    private static final String CONSTRUCTOR_NAME = "<init>";
    private final SemanticModel semanticModel;
    private final List<JavaSymbol> uncompleted = new ArrayList<JavaSymbol>();
    private final SecondPass completer;
    private final Symbols symbols;
    private final ParametrizedTypeCache parametrizedTypeCache;
    private Resolve resolve;
    private Resolve.Env env;

    public FirstPass(SemanticModel semanticModel, Symbols symbols, Resolve resolve, ParametrizedTypeCache parametrizedTypeCache, TypeAndReferenceSolver typeAndReferenceSolver) {
        this.semanticModel = semanticModel;
        this.resolve = resolve;
        this.completer = new SecondPass(semanticModel, symbols, parametrizedTypeCache, typeAndReferenceSolver);
        this.symbols = symbols;
        this.parametrizedTypeCache = parametrizedTypeCache;
    }

    private void restoreEnvironment(Tree tree) {
        if (this.env.next == null) {
            Preconditions.checkState((boolean)tree.is(Tree.Kind.COMPILATION_UNIT));
        } else {
            this.env = this.env.next;
        }
    }

    public void completeSymbols() {
        for (JavaSymbol symbol : this.uncompleted) {
            symbol.complete();
        }
        this.uncompleted.clear();
    }

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        JavaSymbol.PackageJavaSymbol compilationUnitPackage = this.symbols.defaultPackage;
        PackageDeclarationTree packageDeclaration = tree.packageDeclaration();
        if (packageDeclaration != null) {
            ExpressionTree packageName = packageDeclaration.packageName();
            PackageResolverVisitor packageResolver = new PackageResolverVisitor();
            packageName.accept(packageResolver);
            compilationUnitPackage = (JavaSymbol.PackageJavaSymbol)this.resolve.findIdentInPackage(compilationUnitPackage, packageResolver.packageName, 1);
            this.semanticModel.associateSymbol(packageName, compilationUnitPackage);
        }
        compilationUnitPackage.members = new Scope(compilationUnitPackage);
        this.env = new Resolve.Env();
        this.env.packge = compilationUnitPackage;
        this.env.scope = compilationUnitPackage.members;
        this.env.namedImports = new Scope.ImportScope(compilationUnitPackage);
        this.env.starImports = this.resolve.createStarImportScope(compilationUnitPackage);
        this.env.staticStarImports = this.resolve.createStaticStarImportScope(compilationUnitPackage);
        this.semanticModel.associateEnv(tree, this.env);
        this.scan(tree.types());
        this.restoreEnvironment(tree);
        this.resolveImports(tree.imports());
        this.completeSymbols();
    }

    private void resolveImports(List<ImportClauseTree> imports) {
        ImportResolverVisitor importResolverVisitor = new ImportResolverVisitor();
        for (ImportClauseTree importClauseTree : imports) {
            importClauseTree.accept(importResolverVisitor);
        }
    }

    @Override
    public void visitClass(ClassTree tree) {
        int flag = 0;
        boolean anonymousClass = tree.simpleName() == null;
        String name = "";
        if (!anonymousClass) {
            name = tree.simpleName().name();
            flag = this.computeClassFlags(tree);
        }
        JavaSymbol.TypeJavaSymbol symbol = new JavaSymbol.TypeJavaSymbol(flag, name, this.env.scope.owner);
        symbol.declaration = tree;
        ((ClassTreeImpl)tree).setSymbol(symbol);
        if (!anonymousClass) {
            if (this.env.scope.owner.kind == 2 || this.env.scope.owner.kind == 1) {
                this.resolve.registerClass(symbol);
            }
            this.enterSymbol(tree, symbol);
        }
        symbol.members = new Scope(symbol);
        symbol.completer = this.completer;
        this.uncompleted.add(symbol);
        TypeParameters typeParameterTrees = tree.typeParameters();
        this.createNewEnvironment(typeParameterTrees);
        this.semanticModel.saveEnv(symbol, this.env);
        for (TypeParameterTree typeParameterTree : typeParameterTrees) {
            JavaSymbol.TypeVariableJavaSymbol typeVariableSymbol = new JavaSymbol.TypeVariableJavaSymbol(typeParameterTree.identifier().name(), symbol);
            symbol.addTypeParameter((TypeVariableJavaType)typeVariableSymbol.type);
            this.enterSymbol(typeParameterTree, typeVariableSymbol);
        }
        if (!typeParameterTrees.isEmpty()) {
            symbol.type = this.parametrizedTypeCache.getParametrizedTypeType(symbol, new TypeSubstitution());
        }
        symbol.typeParameters = this.env.scope;
        Resolve.Env classEnv = this.env.dup();
        classEnv.outer = this.env;
        classEnv.enclosingClass = symbol;
        classEnv.scope = symbol.members;
        this.env = classEnv;
        this.semanticModel.associateEnv(tree, this.env);
        this.scan(tree.modifiers());
        this.scan(tree.superClass());
        this.scan(tree.superInterfaces());
        this.scan(tree.members());
        if (tree.is(Tree.Kind.ENUM)) {
            JavaSymbol.MethodJavaSymbol valuesMethod = new JavaSymbol.MethodJavaSymbol(symbol.flags & 7 | 8, "values", symbol);
            ArrayJavaType enumArrayType = new ArrayJavaType(symbol.type, this.symbols.arrayClass);
            MethodJavaType valuesMethodType = new MethodJavaType(Collections.emptyList(), enumArrayType, Collections.emptyList(), symbol);
            valuesMethod.setMethodType(valuesMethodType);
            valuesMethod.parameters = new Scope(valuesMethod);
            classEnv.scope.enter(valuesMethod);
            JavaSymbol.MethodJavaSymbol valueOfMethod = new JavaSymbol.MethodJavaSymbol(symbol.flags & 7 | 8, "valueOf", symbol);
            MethodJavaType valueOfMethodType = new MethodJavaType(Collections.singletonList(this.symbols.stringType), symbol.type, Collections.emptyList(), symbol);
            valueOfMethod.setMethodType(valueOfMethodType);
            valueOfMethod.parameters = new Scope(valueOfMethod);
            valueOfMethod.parameters.enter(new JavaSymbol.VariableJavaSymbol(0, "name", this.symbols.stringType, (JavaSymbol)valueOfMethod));
            classEnv.scope.enter(valueOfMethod);
        }
        this.restoreEnvironment(tree);
        this.restoreEnvironment(tree);
    }

    private int computeClassFlags(ClassTree tree) {
        int flags = this.computeFlags(tree.modifiers(), tree);
        if (tree.is(Tree.Kind.INTERFACE)) {
            flags |= 0x200;
        } else if (tree.is(Tree.Kind.ENUM)) {
            flags |= 0x4000;
        } else if (tree.is(Tree.Kind.ANNOTATION_TYPE)) {
            flags |= 0x2200;
        }
        return flags;
    }

    @Override
    public void visitMethod(MethodTree tree) {
        String name = tree.returnType() == null ? CONSTRUCTOR_NAME : tree.simpleName().name();
        JavaSymbol.MethodJavaSymbol symbol = new JavaSymbol.MethodJavaSymbol(this.computeFlags(tree.modifiers(), tree), name, this.env.scope.owner);
        symbol.declaration = tree;
        if (Flags.isFlagged(this.env.scope.owner.flags, 16384) && tree.returnType() == null) {
            symbol.flags |= 2;
        }
        this.enterSymbol(tree, symbol);
        symbol.parameters = new Scope(symbol);
        symbol.completer = this.completer;
        this.uncompleted.add(symbol);
        ((MethodTreeImpl)tree).setSymbol(symbol);
        this.createNewEnvironment(tree.typeParameters());
        for (TypeParameterTree typeParameterTree : tree.typeParameters()) {
            JavaSymbol.TypeVariableJavaSymbol typeVariableSymbol = new JavaSymbol.TypeVariableJavaSymbol(typeParameterTree.identifier().name(), symbol);
            symbol.addTypeParameter((TypeVariableJavaType)typeVariableSymbol.type);
            this.enterSymbol(typeParameterTree, typeVariableSymbol);
        }
        this.semanticModel.saveEnv(symbol, this.env);
        symbol.typeParameters = this.env.scope;
        Resolve.Env methodEnv = this.env.dup();
        methodEnv.scope = symbol.parameters;
        methodEnv.outer = this.env;
        this.env = methodEnv;
        this.scan(tree.modifiers());
        this.scan(tree.returnType());
        this.scan(tree.parameters());
        this.scan(tree.throwsClauses());
        this.scan(tree.defaultValue());
        symbol.defaultValue = FirstPass.getDefaultValueFromTree(tree.defaultValue());
        this.scan(tree.block());
        this.restoreEnvironment(tree);
        this.restoreEnvironment(tree);
    }

    @Nullable
    private static Object getDefaultValueFromTree(@Nullable ExpressionTree expressionTree) {
        if (expressionTree == null) {
            return null;
        }
        if (expressionTree.is(Tree.Kind.STRING_LITERAL)) {
            return LiteralUtils.trimQuotes(((LiteralTree)expressionTree).value());
        }
        if (expressionTree.is(Tree.Kind.INT_LITERAL)) {
            return LiteralUtils.intLiteralValue(expressionTree);
        }
        if (expressionTree.is(Tree.Kind.LONG_LITERAL)) {
            return LiteralUtils.longLiteralValue(expressionTree);
        }
        return null;
    }

    @Override
    public void visitEnumConstant(EnumConstantTree tree) {
        int flags = 16409;
        if (FirstPass.hasDeprecatedAnnotation(tree.modifiers().annotations())) {
            flags |= 0x20000;
        }
        this.declareVariable(flags, tree.simpleName(), (VariableTreeImpl)((Object)tree));
        super.visitEnumConstant(tree);
    }

    @Override
    public void visitVariable(VariableTree tree) {
        this.declareVariable(this.computeFlags(tree.modifiers(), tree), tree.simpleName(), (VariableTreeImpl)tree);
        super.visitVariable(tree);
    }

    private int computeFlags(ModifiersTree modifiers, Tree tree) {
        int result = 0;
        if (Flags.isFlagged(this.env.scope.owner.flags, 512)) {
            result = FirstPass.computeFlagsForInterfaceMember(tree);
        }
        for (ModifierKeywordTree modifier : modifiers.modifiers()) {
            result |= Flags.flagForModifier(modifier.modifier());
        }
        if (FirstPass.hasDeprecatedAnnotation(modifiers.annotations())) {
            result |= 0x20000;
        }
        return result;
    }

    private static int computeFlagsForInterfaceMember(Tree tree) {
        int result;
        if (tree.is(Tree.Kind.METHOD)) {
            MethodTree methodTree = (MethodTree)tree;
            result = ModifiersUtils.hasModifier(methodTree.modifiers(), Modifier.PRIVATE) ? 2 : 1;
            if (methodTree.block() == null) {
                result |= 0x400;
            }
        } else {
            result = 9;
            if (tree.is(Tree.Kind.VARIABLE)) {
                result |= 0x10;
            }
        }
        return result;
    }

    private static boolean hasDeprecatedAnnotation(Iterable<AnnotationTree> annotations) {
        for (AnnotationTree annotationTree : annotations) {
            if (!FirstPass.isDeprecated(annotationTree)) continue;
            return true;
        }
        return false;
    }

    private static boolean isDeprecated(AnnotationTree tree) {
        return tree.annotationType().is(Tree.Kind.IDENTIFIER) && "Deprecated".equals(((IdentifierTree)tree.annotationType()).name());
    }

    private void declareVariable(int flags, IdentifierTree identifierTree, VariableTreeImpl tree) {
        String name = identifierTree.name();
        Object constantValue = this.semanticModel.constantValue(this.env.scope.owner, name);
        JavaSymbol.VariableJavaSymbol symbol = new JavaSymbol.VariableJavaSymbol(flags, name, this.env.scope.owner, constantValue);
        symbol.declaration = tree;
        this.enterSymbol(tree, symbol);
        symbol.completer = this.completer;
        this.uncompleted.add(symbol);
        tree.setSymbol(symbol);
        this.semanticModel.saveEnv(symbol, this.env);
    }

    @Override
    public void visitBlock(BlockTree tree) {
        this.createNewEnvironment(tree);
        super.visitBlock(tree);
        this.restoreEnvironment(tree);
    }

    @Override
    public void visitTryStatement(TryStatementTree tree) {
        if (!FirstPass.declaresResourceAsVariable(tree.resourceList())) {
            super.visitTryStatement(tree);
        } else {
            this.createNewEnvironment(tree.resourceList());
            this.scan(tree.resourceList());
            this.scan(tree.block());
            this.restoreEnvironment(tree.resourceList());
            this.scan(tree.catches());
            this.scan(tree.finallyBlock());
        }
    }

    private static boolean declaresResourceAsVariable(ListTree<Tree> resources) {
        return resources.stream().anyMatch(r -> r.is(Tree.Kind.VARIABLE));
    }

    @Override
    public void visitForStatement(ForStatementTree tree) {
        this.createNewEnvironment(tree);
        super.visitForStatement(tree);
        this.restoreEnvironment(tree);
    }

    @Override
    public void visitForEachStatement(ForEachStatement tree) {
        this.createNewEnvironment(tree);
        super.visitForEachStatement(tree);
        this.restoreEnvironment(tree);
    }

    @Override
    public void visitCatch(CatchTree tree) {
        this.createNewEnvironment(tree);
        super.visitCatch(tree);
        this.restoreEnvironment(tree);
    }

    @Override
    public void visitLambdaExpression(LambdaExpressionTree tree) {
        this.createNewEnvironment(tree);
        super.visitLambdaExpression(tree);
        this.restoreEnvironment(tree);
    }

    @Override
    public void visitSwitchStatement(SwitchStatementTree tree) {
        this.createNewEnvironment(tree);
        super.visitSwitchStatement(tree);
        this.restoreEnvironment(tree);
    }

    private void createNewEnvironment(Tree tree) {
        Scope scope = new Scope(this.env.scope);
        Resolve.Env newEnv = this.env.dup();
        newEnv.scope = scope;
        this.env = newEnv;
        this.semanticModel.associateEnv(tree, this.env);
    }

    private void enterSymbol(Tree tree, JavaSymbol symbol) {
        this.env.scope.enter(symbol);
        this.semanticModel.associateSymbol(tree, symbol);
    }

    private class ImportResolverVisitor
    extends BaseTreeVisitor {
        private JavaSymbol currentSymbol;
        private List<JavaSymbol> resolved;
        private boolean isStatic;

        private ImportResolverVisitor() {
        }

        @Override
        public void visitImport(ImportTree tree) {
            this.currentSymbol = ((FirstPass)FirstPass.this).symbols.defaultPackage;
            this.isStatic = tree.isStatic();
            tree.qualifiedIdentifier().accept(this);
            if (this.currentSymbol.kind < 64) {
                this.enterSymbol(this.currentSymbol, tree);
            } else if (this.isStatic) {
                this.resolved.stream().filter(symbol -> Flags.isFlagged(symbol.flags, 8)).forEach(symbol -> this.enterSymbol((JavaSymbol)symbol, tree));
            }
        }

        private void enterSymbol(JavaSymbol symbol, ImportTree tree) {
            ((FirstPass)FirstPass.this).env.namedImports.enter(symbol);
            if (FirstPass.this.semanticModel.getSymbol(tree) == null) {
                FirstPass.this.semanticModel.associateSymbol(tree, symbol);
            }
        }

        @Override
        public void visitIdentifier(IdentifierTree tree) {
            if (JavaPunctuator.STAR.getValue().equals(tree.name())) {
                if (this.isStatic) {
                    ((FirstPass)FirstPass.this).env.staticStarImports.enter(this.currentSymbol);
                } else {
                    ((FirstPass)FirstPass.this).env.starImports.enter(this.currentSymbol);
                }
                this.currentSymbol = new Resolve.JavaSymbolNotFound();
            } else if (this.currentSymbol.kind == 1) {
                this.currentSymbol = FirstPass.this.resolve.findIdentInPackage(this.currentSymbol, tree.name(), 3);
                this.resolved = Collections.emptyList();
            } else if (this.currentSymbol.kind == 2) {
                this.resolved = ((JavaSymbol.TypeJavaSymbol)this.currentSymbol).members().lookup(tree.name());
                this.currentSymbol = FirstPass.this.resolve.findIdentInType(FirstPass.this.env, (JavaSymbol.TypeJavaSymbol)this.currentSymbol, tree.name(), 6).symbol();
            } else {
                this.currentSymbol = new Resolve.JavaSymbolNotFound();
                this.resolved = Collections.emptyList();
            }
        }
    }

    private static class PackageResolverVisitor
    extends BaseTreeVisitor {
        private String packageName = "";

        @Override
        public void visitIdentifier(IdentifierTree tree) {
            if (!this.packageName.isEmpty()) {
                this.packageName = this.packageName + ".";
            }
            this.packageName = this.packageName + tree.name();
        }
    }
}

