/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import org.sonar.java.bytecode.loader.JarLoader;
import org.sonar.java.bytecode.loader.Loader;

public class AarLoader
implements Loader {
    private static final String CLASSES_JAR_NAME = "classes.jar";
    private final ZipFile aarFile;
    private Path tempClassesJar;
    private JarLoader classesLoader;

    public AarLoader(@Nullable File file) {
        if (file == null) {
            throw new IllegalArgumentException("file can't be null");
        }
        try {
            this.aarFile = new ZipFile(file);
            this.classesLoader = this.extractClassesJar(file.getName());
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to open " + file.getAbsolutePath(), e);
        }
    }

    private JarLoader extractClassesJar(String name) throws IOException {
        ZipEntry classes = this.aarFile.getEntry(CLASSES_JAR_NAME);
        if (classes == null) {
            return null;
        }
        this.tempClassesJar = Files.createTempFile(name, ".jar", new FileAttribute[0]);
        InputStream in = this.aarFile.getInputStream(classes);
        Files.copy(in, this.tempClassesJar, StandardCopyOption.REPLACE_EXISTING);
        return new JarLoader(this.tempClassesJar.toFile());
    }

    @Override
    public URL findResource(String name) {
        if (this.classesLoader != null) {
            return this.classesLoader.findResource(name);
        }
        return null;
    }

    @Override
    public byte[] loadBytes(String name) {
        if (this.classesLoader != null) {
            return this.classesLoader.loadBytes(name);
        }
        return new byte[0];
    }

    @Override
    public void close() {
        try {
            if (this.classesLoader != null) {
                this.classesLoader.close();
                AarLoader.deleteDir(this.tempClassesJar);
            }
            this.aarFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void deleteDir(Path directory) throws IOException {
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

