/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.api.typed.ActionParser;
import java.io.InterruptedIOException;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.AnalysisException;
import org.sonar.java.SonarComponents;
import org.sonar.java.ast.parser.JavaParser;
import org.sonar.java.model.JavaVersionImpl;
import org.sonar.java.model.VisitorsBridge;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.ProgressReport;

public class JavaAstScanner {
    private static final Logger LOG = Loggers.get(JavaAstScanner.class);
    private final ActionParser<Tree> parser;
    private final SonarComponents sonarComponents;
    private VisitorsBridge visitor;

    public JavaAstScanner(ActionParser<Tree> parser, @Nullable SonarComponents sonarComponents) {
        this.parser = parser;
        this.sonarComponents = sonarComponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(Iterable<InputFile> inputFiles) {
        ProgressReport progressReport = new ProgressReport("Report about progress of Java AST analyzer", TimeUnit.SECONDS.toMillis(10L));
        progressReport.start(Iterables.transform(inputFiles, InputFile::toString));
        boolean successfullyCompleted = false;
        boolean cancelled = false;
        try {
            for (InputFile inputFile : inputFiles) {
                if (this.analysisCancelled()) {
                    cancelled = true;
                    break;
                }
                this.simpleScan(inputFile);
                progressReport.nextFile();
            }
            successfullyCompleted = !cancelled;
        }
        finally {
            if (successfullyCompleted) {
                progressReport.stop();
            } else {
                progressReport.cancel();
            }
            this.visitor.endOfAnalysis();
        }
    }

    private boolean analysisCancelled() {
        return this.sonarComponents != null && this.sonarComponents.analysisCancelled();
    }

    private void simpleScan(InputFile inputFile) {
        this.visitor.setCurrentFile(inputFile);
        try {
            String fileContent = inputFile.contents();
            Tree ast = (Tree)this.parser.parse(fileContent);
            this.visitor.visitFile(ast);
        }
        catch (RecognitionException e) {
            JavaAstScanner.checkInterrupted((Exception)((Object)e));
            LOG.error(String.format("Unable to parse source file : '%s'", inputFile));
            LOG.error(e.getMessage());
            this.parseErrorWalkAndVisit(e, inputFile);
        }
        catch (Exception e) {
            JavaAstScanner.checkInterrupted(e);
            throw new AnalysisException(JavaAstScanner.getAnalysisExceptionMessage(inputFile), e);
        }
        catch (StackOverflowError error) {
            LOG.error(String.format("A stack overflow error occured while analyzing file: '%s'", inputFile), (Throwable)error);
            throw error;
        }
    }

    private static void checkInterrupted(Exception e) {
        Throwable cause = Throwables.getRootCause((Throwable)e);
        if (cause instanceof InterruptedException || cause instanceof InterruptedIOException) {
            throw new AnalysisException("Analysis cancelled", e);
        }
    }

    private void parseErrorWalkAndVisit(RecognitionException e, InputFile inputFile) {
        try {
            this.visitor.processRecognitionException(e, inputFile);
        }
        catch (Exception e2) {
            throw new AnalysisException(JavaAstScanner.getAnalysisExceptionMessage(inputFile), e2);
        }
    }

    private static String getAnalysisExceptionMessage(InputFile file) {
        return String.format("SonarQube is unable to analyze file : '%s'", file);
    }

    public void setVisitorBridge(VisitorsBridge visitor) {
        this.visitor = visitor;
    }

    @VisibleForTesting
    public static void scanSingleFileForTests(InputFile file, VisitorsBridge visitorsBridge) {
        JavaAstScanner.scanSingleFileForTests(file, visitorsBridge, new JavaVersionImpl());
    }

    @VisibleForTesting
    public static void scanSingleFileForTests(InputFile inputFile, VisitorsBridge visitorsBridge, JavaVersion javaVersion) {
        JavaAstScanner astScanner = new JavaAstScanner(JavaParser.createParser(), null);
        visitorsBridge.setJavaVersion(javaVersion);
        astScanner.setVisitorBridge(visitorsBridge);
        astScanner.scan(Collections.singleton(inputFile));
    }
}

