/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.filters;

import java.util.List;
import java.util.Set;
import org.sonar.java.checks.AtLeastOneConstructorCheck;
import org.sonar.java.checks.MethodOnlyCallsSuperCheck;
import org.sonar.java.checks.ServletInstanceFieldCheck;
import org.sonar.java.checks.TooManyParametersCheck;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.naming.BadMethodNameCheck;
import org.sonar.java.filters.BaseTreeVisitorIssueFilter;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class SpringFilter
extends BaseTreeVisitorIssueFilter {
    private static final String AUTOWIRED = "org.springframework.beans.factory.annotation.Autowired";
    private static final List<String> S107_METHOD_ANNOTATION_EXCEPTIONS = List.of("org.springframework.web.bind.annotation.RequestMapping", "org.springframework.web.bind.annotation.GetMapping", "org.springframework.web.bind.annotation.PostMapping", "org.springframework.web.bind.annotation.PutMapping", "org.springframework.web.bind.annotation.DeleteMapping", "org.springframework.web.bind.annotation.PatchMapping", "org.springframework.context.annotation.Bean", "org.springframework.beans.factory.annotation.Autowired");
    private static final List<String> S107_CLASS_ANNOTATION_EXCEPTIONS = List.of("org.springframework.stereotype.Component", "org.springframework.context.annotation.Configuration", "org.springframework.stereotype.Service", "org.springframework.stereotype.Repository");

    @Override
    public Set<Class<? extends JavaCheck>> filteredRules() {
        return Set.of(BadMethodNameCheck.class, TooManyParametersCheck.class, MethodOnlyCallsSuperCheck.class, AtLeastOneConstructorCheck.class, ServletInstanceFieldCheck.class);
    }

    public void visitClass(ClassTree tree) {
        this.excludeLinesIfTrue(SpringFilter.isTransactional(tree), (Tree)tree, (Class<? extends JavaCheck>)MethodOnlyCallsSuperCheck.class);
        this.excludeLinesIfTrue(SpringFilter.hasAutowiredField(tree), (Tree)tree.simpleName(), (Class<? extends JavaCheck>)AtLeastOneConstructorCheck.class);
        super.visitClass(tree);
    }

    public void visitVariable(VariableTree tree) {
        this.excludeLinesIfTrue(SpringFilter.isAutowired(tree), (Tree)tree, (Class<? extends JavaCheck>)ServletInstanceFieldCheck.class);
        super.visitVariable(tree);
    }

    public void visitMethod(MethodTree tree) {
        Symbol.MethodSymbol symbol = tree.symbol();
        IdentifierTree reportTree = tree.simpleName();
        if (tree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR})) {
            SymbolMetadata ownerMetadata = symbol.owner().metadata();
            this.excludeLinesIfTrue(S107_CLASS_ANNOTATION_EXCEPTIONS.stream().anyMatch(arg_0 -> ((SymbolMetadata)ownerMetadata).isAnnotatedWith(arg_0)), (Tree)reportTree, (Class<? extends JavaCheck>)TooManyParametersCheck.class);
        } else {
            SymbolMetadata methodMetadata = symbol.metadata();
            this.excludeLinesIfTrue(S107_METHOD_ANNOTATION_EXCEPTIONS.stream().anyMatch(arg_0 -> ((SymbolMetadata)methodMetadata).isAnnotatedWith(arg_0)), (Tree)reportTree, (Class<? extends JavaCheck>)TooManyParametersCheck.class);
            this.excludeLinesIfTrue(SpringFilter.isRepositoryPropertyExpression(symbol), (Tree)reportTree, (Class<? extends JavaCheck>)BadMethodNameCheck.class);
        }
        super.visitMethod(tree);
    }

    private static boolean isRepositoryPropertyExpression(Symbol.MethodSymbol symbol) {
        String name = symbol.name();
        int underscorePosition = name.indexOf(95);
        boolean isSeparatorInMethodName = underscorePosition > 0 && underscorePosition < name.length() - 1;
        return isSeparatorInMethodName && symbol.owner().type().isSubtypeOf("org.springframework.data.repository.Repository");
    }

    private static boolean hasAutowiredField(ClassTree tree) {
        return tree.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})).map(VariableTree.class::cast).anyMatch(SpringFilter::isAutowired);
    }

    private static boolean isAutowired(VariableTree tree) {
        return tree.symbol().metadata().isAnnotatedWith(AUTOWIRED) || SpringFilter.hasUnknownAnnotationWithName(tree.modifiers(), "Autowired");
    }

    private static boolean isTransactional(ClassTree tree) {
        return tree.symbol().metadata().isAnnotatedWith("org.springframework.transaction.annotation.Transactional") || SpringFilter.hasUnknownAnnotationWithName(tree.modifiers(), "Transactional");
    }

    private static boolean hasUnknownAnnotationWithName(ModifiersTree modifiers, String annotation) {
        List annotations = modifiers.annotations();
        if (annotations.isEmpty()) {
            return false;
        }
        return annotations.stream().map(AnnotationTree::annotationType).filter(a -> a.symbolType().isUnknown()).filter(tree -> tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER, Tree.Kind.MEMBER_SELECT})).map(ExpressionTree.class::cast).map(ExpressionsHelper::concatenate).anyMatch(annotationName -> annotationName.endsWith(annotation));
    }
}

