/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5970")
public class SpringAssertionsSimplificationCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE_TEMPLATE = "Replace this assertion by \"%s\".";
    private static final String[] ASSERTION_CLASSES = new String[]{"org.junit.Assert", "junit.framework.TestCase", "junit.framework.Assert", "org.junit.jupiter.api.Assertions"};
    private static final String[] ASSERT_J_AND_FEST_ASSERT = new String[]{"org.assertj.core.api.AbstractAssert", "org.fest.assertions.GenericAssert"};
    private static final MethodMatchers ASSERT_EQUALS_MATCHER = MethodMatchers.create().ofTypes(ASSERTION_CLASSES).names(new String[]{"assertEquals"}).addParametersMatcher(new String[]{"*", "*"}).build();
    private static final MethodMatchers ASSERT_TRUE_FALSE_EQUALS_MATCHER = MethodMatchers.create().ofTypes(ASSERTION_CLASSES).names(new String[]{"assertEquals", "assertTrue", "assertFalse"}).withAnyParameters().build();
    private static final MethodMatchers MODEL_VIEW_GET_VIEW_NAME = MethodMatchers.create().ofTypes(new String[]{"org.springframework.web.servlet.ModelAndView"}).names(new String[]{"getViewName"}).addWithoutParametersMatcher().build();
    private static final MethodMatchers MODEL_MAP_GET = MethodMatchers.create().ofTypes(new String[]{"org.springframework.ui.ModelMap"}).names(new String[]{"get"}).addParametersMatcher(new String[]{"java.lang.Object"}).build();
    private static final MethodMatchers ASSERT_THAT = MethodMatchers.create().ofTypes(new String[]{"org.assertj.core.api.Assertions", "org.fest.assertions.Assertions"}).names(new String[]{"assertThat"}).withAnyParameters().build();
    private static final MethodMatchers IS_EQUAL_TO = MethodMatchers.create().ofSubTypes(ASSERT_J_AND_FEST_ASSERT).names(new String[]{"isEqualTo"}).withAnyParameters().build();
    private static final MethodMatchers IS_EQUAL_TO_IS_FALSE_IS_TRUE = MethodMatchers.create().ofSubTypes(ASSERT_J_AND_FEST_ASSERT).names(new String[]{"isEqualTo", "isTrue", "isFalse"}).withAnyParameters().build();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        MethodInvocationTree mit = (MethodInvocationTree)tree;
        if (MODEL_VIEW_GET_VIEW_NAME.matches(mit)) {
            SpringAssertionsSimplificationCheck.getNestingCall(tree).ifPresent(call -> {
                if (ASSERT_EQUALS_MATCHER.matches(call) || ASSERT_THAT.matches(call) && MethodTreeUtils.subsequentMethodInvocation((Tree)call, IS_EQUAL_TO).isPresent()) {
                    this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)call), String.format(MESSAGE_TEMPLATE, "ModelAndViewAssert.assertViewName"));
                }
            });
        } else if (MODEL_MAP_GET.matches(mit)) {
            SpringAssertionsSimplificationCheck.getNestingCall(tree).ifPresent(call -> {
                if (ASSERT_TRUE_FALSE_EQUALS_MATCHER.matches(call) || ASSERT_THAT.matches(call) && MethodTreeUtils.subsequentMethodInvocation((Tree)call, IS_EQUAL_TO_IS_FALSE_IS_TRUE).isPresent()) {
                    this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)call), String.format(MESSAGE_TEMPLATE, "ModelAndViewAssert.assertModelAttributeValue"));
                }
            });
        }
    }

    private static Optional<MethodInvocationTree> getNestingCall(Tree nestedTree) {
        for (Tree parent = nestedTree.parent(); parent != null && !parent.is(new Tree.Kind[]{Tree.Kind.METHOD}); parent = parent.parent()) {
            if (!parent.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) continue;
            return Optional.of((MethodInvocationTree)parent);
        }
        return Optional.empty();
    }
}

