/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.Collections;
import java.util.List;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

public abstract class AbstractMockitoArgumentChecker
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers METHODS_USING_ARGUMENT_MATCHER_IN_ARGUMENTS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"org.mockito.Mockito"}).names(new String[]{"when"}).addParametersMatcher(new String[]{"*"}).build(), MethodMatchers.create().ofTypes(new String[]{"org.mockito.BDDMockito"}).names(new String[]{"given"}).addParametersMatcher(new String[]{"*"}).build()});
    private static final MethodMatchers METHODS_USING_ARGUMENT_MATCHER_IN_CONSECUTIVE_CALL = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"org.mockito.Mockito"}).names(new String[]{"verify"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"org.mockito.InOrder"}).names(new String[]{"verify"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"org.mockito.stubbing.Stubber"}).names(new String[]{"when"}).withAnyParameters().build()});

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        MethodInvocationTree invocation = (MethodInvocationTree)tree;
        if (METHODS_USING_ARGUMENT_MATCHER_IN_ARGUMENTS.matches(invocation)) {
            ExpressionTree argument = (ExpressionTree)invocation.arguments().get(0);
            argument = ExpressionUtils.skipParentheses((ExpressionTree)argument);
            if (argument.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                this.visitArguments(((MethodInvocationTree)argument).arguments());
            }
        } else if (METHODS_USING_ARGUMENT_MATCHER_IN_CONSECUTIVE_CALL.matches(invocation)) {
            MethodTreeUtils.consecutiveMethodInvocation((Tree)invocation).ifPresent(m -> this.visitArguments(m.arguments()));
        }
    }

    protected abstract void visitArguments(Arguments var1);
}

