/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.AnalysisException;
import org.sonar.java.model.DefaultJavaFileScannerContext;
import org.sonar.java.model.DefaultModuleScannerContext;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.plugins.java.api.InputFileScannerContext;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.ModuleScannerContext;
import org.sonar.plugins.java.api.caching.CacheContext;
import org.sonar.plugins.java.api.caching.JavaReadCache;
import org.sonar.plugins.java.api.caching.JavaWriteCache;
import org.sonar.plugins.java.api.internal.EndOfAnalysis;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5693")
public class ExcessiveContentRequestCheck
extends IssuableSubscriptionVisitor
implements EndOfAnalysis {
    @RuleProperty(key="fileUploadSizeLimit", description="The maximum size of HTTP requests handling file uploads (in bytes).", defaultValue="8388608")
    public long fileUploadSizeLimit = 0x800000L;
    private static final long BYTES_PER_KB = 1024L;
    private static final long BYTES_PER_MB = 0x100000L;
    private static final long BYTES_PER_GB = 0x40000000L;
    private static final long BYTES_PER_TB = 0x10000000000L;
    private static final long DEFAULT_MAX = 0x800000L;
    private static final String MESSAGE_EXCEED_SIZE = "The content length limit of %d bytes is greater than the defined limit of %d; make sure it is safe here.";
    private static final String MESSAGE_SIZE_NOT_SET = "Make sure not setting any maximum content length limit is safe here.";
    private static final Pattern DATA_SIZE_PATTERN = Pattern.compile("^([+\\-]?\\d+)([a-zA-Z]{0,2})$");
    private static final String MULTIPART_RESOLVER = "org.springframework.web.multipart.commons.CommonsMultipartResolver";
    private static final String MULTIPART_CONFIG = "org.springframework.boot.web.servlet.MultipartConfigFactory";
    private static final MethodMatchers METHODS_SETTING_MAX_SIZE = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofSubTypes(new String[]{"org.springframework.web.multipart.commons.CommonsMultipartResolver"}).names(new String[]{"setMaxUploadSize"}).addParametersMatcher(new String[]{"long"}).build(), MethodMatchers.create().ofSubTypes(new String[]{"org.springframework.boot.web.servlet.MultipartConfigFactory"}).names(new String[]{"setMaxFileSize", "setMaxRequestSize"}).addParametersMatcher(new String[]{"long"}).addParametersMatcher(new String[]{"java.lang.String"}).build()});
    private static final MethodMatchers MULTIPART_CONSTRUCTOR = MethodMatchers.create().ofSubTypes(new String[]{"org.springframework.web.multipart.commons.CommonsMultipartResolver", "org.springframework.boot.web.servlet.MultipartConfigFactory"}).constructor().withAnyParameters().build();
    private static final String DATA_SIZE = "org.springframework.util.unit.DataSize";
    private static final MethodMatchers DATA_SIZE_OF_SOMETHING = MethodMatchers.create().ofSubTypes(new String[]{"org.springframework.util.unit.DataSize"}).name(name -> name.startsWith("of")).addParametersMatcher(new String[]{"long"}).build();
    private static final MethodMatchers DATA_SIZE_WITH_UNIT = MethodMatchers.create().ofSubTypes(new String[]{"org.springframework.util.unit.DataSize"}).names(new String[]{"parse", "of"}).addParametersMatcher(new String[]{"*", "org.springframework.util.unit.DataUnit"}).build();
    private static final MethodMatchers DATA_SIZE_PARSE = MethodMatchers.create().ofSubTypes(new String[]{"org.springframework.util.unit.DataSize"}).names(new String[]{"parse"}).addParametersMatcher(new String[]{"java.lang.CharSequence"}).build();
    public static final String CACHE_KEY_CACHED = "java:S5693:cached";
    public static final String CACHE_KEY_INSTANTIATE = "java:S5693:instantiate";
    public static final String CACHE_KEY_SET_MAXIMUM_SIZE = "java:S5693:maximumSize";
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcessiveContentRequestCheck.class);
    private final List<AnalyzerMessage> multipartConstructorIssues = new ArrayList<AnalyzerMessage>();
    private boolean sizeSetSomewhere = false;
    private Set<String> filesCached = new HashSet<String>();
    private boolean currentFileSetsMaximumSize = false;
    private boolean currentFileInstantiates = false;

    public boolean scanWithoutParsing(InputFileScannerContext context) {
        InputFile unchangedFile = context.getInputFile();
        CacheContext cacheContext = context.getCacheContext();
        Optional<CachedResult> cachedEntry = ExcessiveContentRequestCheck.loadFromPreviousAnalysis(cacheContext, unchangedFile);
        if (cachedEntry.isEmpty()) {
            LOGGER.trace("No cached data for rule java:S5693 on file {}", (Object)unchangedFile);
            return false;
        }
        boolean inputFileSetsMaximumSize = cachedEntry.get().setMaximumSize;
        if (inputFileSetsMaximumSize) {
            this.sizeSetSomewhere = true;
        }
        ExcessiveContentRequestCheck.keepForNextAnalysis(cacheContext, context.getInputFile());
        this.filesCached.add(unchangedFile.key());
        return true;
    }

    public void endOfAnalysis(ModuleScannerContext context) {
        if (!this.sizeSetSomewhere) {
            DefaultModuleScannerContext defaultContext = (DefaultModuleScannerContext)context;
            this.multipartConstructorIssues.forEach(arg_0 -> ((DefaultModuleScannerContext)defaultContext).reportIssue(arg_0));
        }
        this.filesCached.clear();
        this.multipartConstructorIssues.clear();
        this.sizeSetSomewhere = false;
    }

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        DefaultJavaFileScannerContext defaultContext = (DefaultJavaFileScannerContext)this.context;
        if (tree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
            NewClassTree newClassTree = (NewClassTree)tree;
            if (MULTIPART_CONSTRUCTOR.matches(newClassTree)) {
                AnalyzerMessage analyzerMessage = defaultContext.createAnalyzerMessage((JavaCheck)this, (Tree)newClassTree, MESSAGE_SIZE_NOT_SET);
                this.multipartConstructorIssues.add(analyzerMessage);
                this.currentFileInstantiates = true;
            }
        } else {
            MethodInvocationTree mit = (MethodInvocationTree)tree;
            if (METHODS_SETTING_MAX_SIZE.matches(mit)) {
                this.currentFileSetsMaximumSize = true;
                this.sizeSetSomewhere = true;
                this.getIfExceedSize((ExpressionTree)mit.arguments().get(0)).map(bytesExceeding -> defaultContext.createAnalyzerMessage((JavaCheck)this, (Tree)mit, String.format(MESSAGE_EXCEED_SIZE, bytesExceeding, this.fileUploadSizeLimit))).ifPresent(arg_0 -> ((DefaultJavaFileScannerContext)defaultContext).reportIssue(arg_0));
            }
        }
    }

    public void leaveFile(JavaFileScannerContext context) {
        super.leaveFile(context);
        CacheContext cacheContext = context.getCacheContext();
        if (cacheContext.isCacheEnabled()) {
            ExcessiveContentRequestCheck.writeForNextAnalysis(cacheContext, context.getInputFile(), this.currentFileInstantiates, this.currentFileSetsMaximumSize);
        }
        this.currentFileSetsMaximumSize = false;
        this.currentFileInstantiates = false;
    }

    private Optional<Long> getIfExceedSize(ExpressionTree expressionTree) {
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            return ExcessiveContentRequestCheck.getSizeFromDataSize((MethodInvocationTree)expressionTree).filter(b -> b > this.fileUploadSizeLimit);
        }
        return ExcessiveContentRequestCheck.getNumberOfBytes(expressionTree).filter(b -> b > this.fileUploadSizeLimit);
    }

    private static Optional<Long> getSizeFromDataSize(MethodInvocationTree mit) {
        Optional<Long> multiplier;
        if (DATA_SIZE_PARSE.matches(mit)) {
            return ExcessiveContentRequestCheck.getNumberOfBytes((ExpressionTree)mit.arguments().get(0));
        }
        if (DATA_SIZE_OF_SOMETHING.matches(mit)) {
            return ExcessiveContentRequestCheck.getNumberOfBytes((ExpressionTree)mit.arguments().get(0)).map(b -> b * ExcessiveContentRequestCheck.getMultiplierFromName(ExpressionUtils.methodName((MethodInvocationTree)mit).name()));
        }
        if (DATA_SIZE_WITH_UNIT.matches(mit) && (multiplier = ExcessiveContentRequestCheck.getIdentifierName((ExpressionTree)mit.arguments().get(1)).map(ExcessiveContentRequestCheck::getMultiplierFromName)).isPresent()) {
            return ExcessiveContentRequestCheck.getNumberOfBytes((ExpressionTree)mit.arguments().get(0)).map(l -> l * (Long)multiplier.get());
        }
        return Optional.empty();
    }

    private static Optional<Long> getNumberOfBytes(ExpressionTree expression) {
        Optional integerOptional = expression.asConstant(Integer.class);
        if (integerOptional.isPresent()) {
            return Optional.of(((Integer)integerOptional.get()).longValue());
        }
        Optional stringOptional = expression.asConstant(String.class);
        if (stringOptional.isPresent()) {
            return ExcessiveContentRequestCheck.getLongValueFromString((String)stringOptional.get());
        }
        return expression.asConstant(Long.class);
    }

    private static Optional<Long> getLongValueFromString(String s) {
        Matcher matcher = DATA_SIZE_PATTERN.matcher(s);
        if (matcher.matches()) {
            return Optional.of(Long.parseLong(matcher.group(1)) * ExcessiveContentRequestCheck.getMultiplierFromName(matcher.group(2)));
        }
        return Optional.empty();
    }

    private static Long getMultiplierFromName(String name) {
        switch (name.toUpperCase(Locale.ENGLISH)) {
            case "OFKILOBYTES": 
            case "KILOBYTES": 
            case "KB": {
                return 1024L;
            }
            case "OFMEGABYTES": 
            case "MEGABYTES": 
            case "MB": {
                return 0x100000L;
            }
            case "OFGIGABYTES": 
            case "GIGABYTES": 
            case "GB": {
                return 0x40000000L;
            }
            case "OFTERABYTES": 
            case "TERABYTES": 
            case "TB": {
                return 0x10000000000L;
            }
        }
        return 1L;
    }

    private static Optional<String> getIdentifierName(ExpressionTree expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return Optional.of(((IdentifierTree)expression).name());
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return Optional.of(((MemberSelectExpressionTree)expression).identifier().name());
        }
        return Optional.empty();
    }

    private static String computeCacheKey(InputFile inputFile) {
        return "java:S5693:" + inputFile.key();
    }

    private static Optional<CachedResult> loadFromPreviousAnalysis(CacheContext cacheContext, InputFile inputFile) {
        String cacheKey;
        JavaReadCache readCache = cacheContext.getReadCache();
        byte[] rawValue = readCache.readBytes(cacheKey = ExcessiveContentRequestCheck.computeCacheKey(inputFile));
        if (rawValue == null) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(CachedResult.fromBytes(rawValue));
        }
        catch (IllegalArgumentException ignored) {
            LOGGER.trace("Cached entry is unreadable for rule java:S5693 on file {}", (Object)inputFile);
            return Optional.empty();
        }
    }

    private static void keepForNextAnalysis(CacheContext cacheContext, InputFile inputFile) {
        JavaWriteCache writeCache = cacheContext.getWriteCache();
        try {
            writeCache.copyFromPrevious(ExcessiveContentRequestCheck.computeCacheKey(inputFile));
        }
        catch (IllegalArgumentException e) {
            String message = String.format("Failed to copy from previous cache for file %s", inputFile);
            LOGGER.trace(message);
            throw new AnalysisException(message, (Throwable)e);
        }
    }

    private static void writeForNextAnalysis(CacheContext cacheContext, InputFile inputFile, boolean instantiates, boolean setsMaximumSize) {
        JavaWriteCache writeCache = cacheContext.getWriteCache();
        try {
            writeCache.write(ExcessiveContentRequestCheck.computeCacheKey(inputFile), CachedResult.toBytes(new CachedResult(instantiates, setsMaximumSize)));
        }
        catch (IllegalArgumentException e) {
            String message = String.format("Failed to write to cache for file %s", inputFile);
            LOGGER.trace(message);
            throw new AnalysisException(message, (Throwable)e);
        }
    }

    static class CachedResult {
        public static final byte INSTANTIATES_VALUE = 1;
        public static final byte SETS_MAXIMUM_SIZE_VALUE = 2;
        public final boolean instantiates;
        public final boolean setMaximumSize;

        CachedResult(boolean instantiates, boolean setMaximumSize) {
            this.instantiates = instantiates;
            this.setMaximumSize = setMaximumSize;
        }

        static CachedResult fromBytes(byte[] raw) {
            if (raw.length != 1) {
                throw new IllegalArgumentException(String.format("Could not decode cached result: unexpected length (expected = 1, actual = %d)", raw.length));
            }
            return new CachedResult((raw[0] & 1) == 1, (raw[0] & 2) == 2);
        }

        static byte[] toBytes(CachedResult cachedResult) {
            byte value = 0;
            if (cachedResult.instantiates) {
                value = (byte)(value | 1);
            }
            if (cachedResult.setMaximumSize) {
                value = (byte)(value | 2);
            }
            return new byte[]{value};
        }
    }
}

