/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.aws;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.java.checks.helpers.TreeHelper;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

public abstract class AbstractAwsMethodVisitor
extends IssuableSubscriptionVisitor {
    private static final List<Tree.Kind> NODES_TO_VISIT = List.of(Tree.Kind.METHOD);
    protected static final MethodMatchers HANDLE_REQUEST_MATCHER = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofSubTypes(new String[]{"com.amazonaws.services.lambda.runtime.RequestHandler"}).names(new String[]{"handleRequest"}).addParametersMatcher(new String[]{"java.lang.Object", "com.amazonaws.services.lambda.runtime.Context"}).build(), MethodMatchers.create().ofSubTypes(new String[]{"com.amazonaws.services.lambda.runtime.RequestStreamHandler"}).names(new String[]{"handleRequest"}).addParametersMatcher(new String[]{"java.io.InputStream", "java.io.OutputStream", "com.amazonaws.services.lambda.runtime.Context"}).build()});

    public List<Tree.Kind> nodesToVisit() {
        return NODES_TO_VISIT;
    }

    public void visitNode(Tree handleRequestMethodTree) {
        MethodTree methodTree = (MethodTree)handleRequestMethodTree;
        if (!HANDLE_REQUEST_MATCHER.matches(methodTree)) {
            return;
        }
        HashSet<MethodTree> methodTrees = new HashSet<MethodTree>();
        methodTrees.addAll(TreeHelper.findReachableMethodsInSameFile((Tree)methodTree));
        methodTrees.add(methodTree);
        this.visitReachableMethodsFromHandleRequest(methodTrees);
    }

    abstract void visitReachableMethodsFromHandleRequest(Set<MethodTree> var1);
}

