/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5194")
public class UseSwitchExpressionCheck
extends IssuableSubscriptionVisitor
implements JavaVersionAwareVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.SWITCH_STATEMENT);
    }

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.asInt() >= 14;
    }

    public void visitNode(Tree tree) {
        SwitchStatementTree switchTree = (SwitchStatementTree)tree;
        Symbol switchAssigningVariable = UseSwitchExpressionCheck.isSwitchAssigningVariable(switchTree);
        if (switchAssigningVariable != null) {
            this.reportIssue((Tree)switchTree.switchKeyword(), "Use \"switch\" expression to set value of \"" + switchAssigningVariable.name() + "\".");
        } else if (UseSwitchExpressionCheck.isSwitchReturningValue(switchTree)) {
            this.reportIssue((Tree)switchTree.switchKeyword(), "Use \"switch\" expression to return the value from method.");
        }
    }

    @CheckForNull
    private static Symbol isSwitchAssigningVariable(SwitchStatementTree switchStatementTree) {
        Set assignedVariables = switchStatementTree.cases().stream().filter(caseGroup -> !UseSwitchExpressionCheck.hasSingleStatement(caseGroup.body(), Tree.Kind.THROW_STATEMENT)).map(UseSwitchExpressionCheck::assigningVariable).collect(Collectors.toSet());
        return assignedVariables.size() == 1 ? (Symbol)assignedVariables.iterator().next() : null;
    }

    private static boolean isSwitchReturningValue(SwitchStatementTree switchStatementTree) {
        return switchStatementTree.cases().stream().map(CaseGroupTree::body).allMatch(body -> UseSwitchExpressionCheck.hasSingleStatement(body, Tree.Kind.THROW_STATEMENT, Tree.Kind.RETURN_STATEMENT));
    }

    @CheckForNull
    private static Symbol assigningVariable(CaseGroupTree caseGroup) {
        List body = caseGroup.body();
        if (UseSwitchExpressionCheck.isArrowOrBreaks(caseGroup)) {
            return UseSwitchExpressionCheck.variableFromAssignment(body);
        }
        return null;
    }

    @CheckForNull
    private static Symbol variableFromAssignment(List<StatementTree> body) {
        Symbol variable;
        ExpressionTree expression;
        if (body.isEmpty()) {
            return null;
        }
        StatementTree statementTree = body.get(0);
        if (statementTree.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT}) && (expression = ((ExpressionStatementTree)statementTree).expression()).is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT}) && (variable = UseSwitchExpressionCheck.getVariableSymbol((AssignmentExpressionTree)expression)) != null && !variable.isUnknown()) {
            return variable;
        }
        if (statementTree.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            return UseSwitchExpressionCheck.variableFromAssignment(((BlockTree)statementTree).body());
        }
        return null;
    }

    private static boolean isArrowOrBreaks(CaseGroupTree caseGroup) {
        List body = caseGroup.body();
        return !((CaseLabelTree)caseGroup.labels().get(0)).isFallThrough() || UseSwitchExpressionCheck.hasBreak(body) || UseSwitchExpressionCheck.hasSingleStatement(body, Tree.Kind.BLOCK) && UseSwitchExpressionCheck.hasBreak(((BlockTree)body.get(0)).body());
    }

    private static boolean hasBreak(List<StatementTree> body) {
        return body.size() == 2 && body.get(1).is(new Tree.Kind[]{Tree.Kind.BREAK_STATEMENT});
    }

    @CheckForNull
    private static Symbol getVariableSymbol(AssignmentExpressionTree expression) {
        ExpressionTree variable = expression.variable();
        if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return ((IdentifierTree)variable).symbol();
        }
        if (variable.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return ((MemberSelectExpressionTree)variable).identifier().symbol();
        }
        return null;
    }

    private static boolean hasSingleStatement(List<StatementTree> body, Tree.Kind ... statement) {
        if (body.size() != 1) {
            return false;
        }
        StatementTree onlyStatement = body.get(0);
        return onlyStatement.is(statement) || onlyStatement.is(new Tree.Kind[]{Tree.Kind.BLOCK}) && UseSwitchExpressionCheck.hasSingleStatement(((BlockTree)onlyStatement).body(), statement);
    }
}

