/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JUtils;
import org.sonar.java.model.LineUtils;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.location.Position;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1612")
public class ReplaceLambdaByMethodRefCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.LAMBDA_EXPRESSION);
    }

    public void visitNode(Tree tree) {
        this.visitLambdaExpression((LambdaExpressionTree)tree);
    }

    private void visitLambdaExpression(LambdaExpressionTree tree) {
        ReplaceLambdaByMethodRefCheck.getPossibleReplacement(tree).filter(replacement -> ReplaceLambdaByMethodRefCheck.isReplacementMoreConcise(tree, replacement)).ifPresent(replacement -> QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)tree.arrowToken()).withMessage("Replace this lambda with method reference '%s'.%s", new Object[]{replacement, this.context.getJavaVersion().java8CompatibilityMessage()}).withQuickFix(() -> JavaQuickFix.newQuickFix((String)"Replace with \"%s\"", (Object[])new Object[]{replacement}).addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTree((Tree)tree, (String)replacement)}).build()).report());
    }

    private static boolean isReplacementMoreConcise(LambdaExpressionTree tree, String replacement) {
        SyntaxToken first = Objects.requireNonNull(tree.firstToken());
        SyntaxToken last = Objects.requireNonNull(tree.lastToken());
        boolean multiline = LineUtils.startLine((SyntaxToken)first) != LineUtils.endLine((SyntaxToken)last);
        boolean shorter = replacement.length() <= Position.endOf((SyntaxToken)last).column() - Position.startOf((SyntaxToken)first).column();
        return multiline || shorter;
    }

    private static Optional<String> getPossibleReplacement(LambdaExpressionTree tree) {
        Optional<String> typeCastOrInstanceOf = ReplaceLambdaByMethodRefCheck.getTypeCastOrInstanceOf(tree);
        if (typeCastOrInstanceOf.isPresent()) {
            return typeCastOrInstanceOf;
        }
        Optional<String> nullCheck = ReplaceLambdaByMethodRefCheck.getNullCheck(tree);
        if (nullCheck.isPresent()) {
            return nullCheck;
        }
        Optional<String> methodInvocationOrNewClass = ReplaceLambdaByMethodRefCheck.getMethodInvocationOrNewClass(tree.body(), tree);
        if (methodInvocationOrNewClass.isPresent()) {
            return methodInvocationOrNewClass;
        }
        return ReplaceLambdaByMethodRefCheck.getBodyBlockInvokingMethodOrNewClass(tree);
    }

    private static Optional<String> getNullCheck(LambdaExpressionTree lambda) {
        return ReplaceLambdaByMethodRefCheck.getLambdaSingleParamSymbol(lambda).flatMap(symbol -> {
            Tree lambdaBody = lambda.body();
            return ReplaceLambdaByMethodRefCheck.isBlockWithOneStatement(lambdaBody) ? ReplaceLambdaByMethodRefCheck.getNullCheckFromReturn((Tree)((BlockTree)lambdaBody).body().get(0), symbol) : ReplaceLambdaByMethodRefCheck.getNullCheck(lambdaBody, symbol);
        });
    }

    private static Optional<String> getNullCheckFromReturn(Tree statement, Symbol paramSymbol) {
        return statement.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT}) ? ReplaceLambdaByMethodRefCheck.getNullCheck((Tree)((ReturnStatementTree)statement).expression(), paramSymbol) : Optional.empty();
    }

    private static Optional<String> getNullCheck(@Nullable Tree statement, Symbol paramSymbol) {
        return ReplaceLambdaByMethodRefCheck.expressionWithoutParentheses(statement).flatMap(expr -> {
            ExpressionTree rightOperand;
            BinaryExpressionTree bet;
            ExpressionTree leftOperand;
            if (expr.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO}) && (ReplaceLambdaByMethodRefCheck.nullAgainstParam(leftOperand = ExpressionUtils.skipParentheses((ExpressionTree)(bet = (BinaryExpressionTree)expr).leftOperand()), rightOperand = ExpressionUtils.skipParentheses((ExpressionTree)bet.rightOperand()), paramSymbol) || ReplaceLambdaByMethodRefCheck.nullAgainstParam(rightOperand, leftOperand, paramSymbol))) {
                return Optional.of(expr.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO}) ? "Objects::isNull" : "Objects::nonNull");
            }
            return Optional.empty();
        });
    }

    private static boolean nullAgainstParam(ExpressionTree o1, ExpressionTree o2, Symbol paramSymbol) {
        return o1.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL}) && o2.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && paramSymbol.equals((Object)((IdentifierTree)o2).symbol());
    }

    private static Optional<String> getTypeCastOrInstanceOf(LambdaExpressionTree lambda) {
        return ReplaceLambdaByMethodRefCheck.getLambdaSingleParamSymbol(lambda).flatMap(symbol -> {
            Tree lambdaBody = lambda.body();
            return ReplaceLambdaByMethodRefCheck.isBlockWithOneStatement(lambdaBody) ? ReplaceLambdaByMethodRefCheck.getTypeCastOrInstanceOfFromReturn((Tree)((BlockTree)lambdaBody).body().get(0), symbol) : ReplaceLambdaByMethodRefCheck.getTypeCastOrInstanceOf(lambdaBody, symbol);
        });
    }

    private static Optional<String> getTypeCastOrInstanceOfFromReturn(Tree statement, Symbol symbol) {
        return statement.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT}) ? ReplaceLambdaByMethodRefCheck.getTypeCastOrInstanceOf((Tree)((ReturnStatementTree)statement).expression(), symbol) : Optional.empty();
    }

    private static Optional<String> getTypeCastOrInstanceOf(@Nullable Tree statement, Symbol symbol) {
        return statement == null ? Optional.empty() : ReplaceLambdaByMethodRefCheck.expressionWithoutParentheses(statement).flatMap(expr -> ReplaceLambdaByMethodRefCheck.getTypeCastOrInstanceOfName(symbol, expr));
    }

    private static Optional<String> getTypeCastOrInstanceOfName(Symbol symbol, ExpressionTree expr) {
        InstanceOfTree instanceOfTree;
        if (expr.is(new Tree.Kind[]{Tree.Kind.TYPE_CAST})) {
            TypeCastTree typeCastTree = (TypeCastTree)expr;
            if (ReplaceLambdaByMethodRefCheck.isSingleParamExpression(typeCastTree.expression(), symbol) && !symbol.type().isPrimitive()) {
                return ReplaceLambdaByMethodRefCheck.getTypeName(typeCastTree.type()).map(s -> s + ".class::cast");
            }
        } else if (expr.is(new Tree.Kind[]{Tree.Kind.INSTANCE_OF}) && ReplaceLambdaByMethodRefCheck.isSingleParamExpression((instanceOfTree = (InstanceOfTree)expr).expression(), symbol)) {
            return ReplaceLambdaByMethodRefCheck.getTypeName(instanceOfTree.type()).map(s -> s + ".class::isInstance");
        }
        return Optional.empty();
    }

    private static Optional<String> getTypeName(TypeTree type) {
        if (type.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && !ReplaceLambdaByMethodRefCheck.isGeneric((IdentifierTree)type)) {
            return Optional.of(((IdentifierTree)type).name());
        }
        if (type.is(new Tree.Kind[]{Tree.Kind.ARRAY_TYPE})) {
            return ReplaceLambdaByMethodRefCheck.getTypeName(((ArrayTypeTree)type).type()).map(x -> x + "[]");
        }
        if (type.is(new Tree.Kind[]{Tree.Kind.PRIMITIVE_TYPE})) {
            return Optional.of(((PrimitiveTypeTree)type).keyword().text());
        }
        return Optional.empty();
    }

    private static boolean isGeneric(IdentifierTree identifierTree) {
        return JUtils.isTypeVar((Type)identifierTree.symbolType());
    }

    private static boolean isSingleParamExpression(ExpressionTree expression, Symbol symbol) {
        return expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && symbol.equals((Object)((IdentifierTree)expression).symbol());
    }

    private static Optional<Symbol> getLambdaSingleParamSymbol(LambdaExpressionTree tree) {
        List parameters = tree.parameters();
        return parameters.size() == 1 ? Optional.of(((VariableTree)parameters.get(0)).symbol()) : Optional.empty();
    }

    private static Optional<String> getBodyBlockInvokingMethodOrNewClass(LambdaExpressionTree lambdaTree) {
        Tree lambdaBody = lambdaTree.body();
        if (ReplaceLambdaByMethodRefCheck.isBlockWithOneStatement(lambdaBody)) {
            Tree statement = (Tree)((BlockTree)lambdaBody).body().get(0);
            return ReplaceLambdaByMethodRefCheck.getExpressionOrReturnStatementInvokingMethod(statement, lambdaTree);
        }
        return Optional.empty();
    }

    private static boolean isBlockWithOneStatement(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.BLOCK}) && ((BlockTree)tree).body().size() == 1;
    }

    private static Optional<String> getExpressionOrReturnStatementInvokingMethod(Tree statement, LambdaExpressionTree lambdaTree) {
        if (statement.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT})) {
            return ReplaceLambdaByMethodRefCheck.getMethodInvocationOrNewClass((Tree)((ExpressionStatementTree)statement).expression(), lambdaTree);
        }
        if (statement.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT})) {
            return ReplaceLambdaByMethodRefCheck.getMethodInvocationOrNewClass((Tree)((ReturnStatementTree)statement).expression(), lambdaTree);
        }
        return Optional.empty();
    }

    private static Optional<String> getMethodInvocationOrNewClass(@Nullable Tree tree, LambdaExpressionTree lambdaTree) {
        if (tree != null) {
            List parameters = lambdaTree.parameters();
            if (tree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
                return ReplaceLambdaByMethodRefCheck.getNewClass((NewClassTree)tree, parameters);
            }
            if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                MethodInvocationTree mit = (MethodInvocationTree)tree;
                if (mit.methodSymbol().isUnknown() || ReplaceLambdaByMethodRefCheck.hasMethodInvocationInMethodSelect(mit) || ReplaceLambdaByMethodRefCheck.hasNonFinalFieldInMethodSelect(mit)) {
                    return Optional.empty();
                }
                if (ReplaceLambdaByMethodRefCheck.matchingParameters(mit.arguments(), parameters)) {
                    return ReplaceLambdaByMethodRefCheck.getReplacementForMethodInvocation(mit);
                }
                if (ReplaceLambdaByMethodRefCheck.isMethodCalledOnFirstParam(mit, parameters)) {
                    return ReplaceLambdaByMethodRefCheck.getUnambiguousReference(mit);
                }
            }
        }
        return Optional.empty();
    }

    private static Optional<String> getUnambiguousReference(MethodInvocationTree mit) {
        Symbol.MethodSymbol ms = mit.methodSymbol();
        ArrayList<Symbol.MethodSymbol> methodSymbols = new ArrayList<Symbol.MethodSymbol>(ms.overriddenSymbols());
        Collections.reverse(methodSymbols);
        methodSymbols.add(ms);
        return methodSymbols.stream().filter(m -> m.thrownTypes().equals(ms.thrownTypes())).filter(m -> !ReplaceLambdaByMethodRefCheck.hasAmbiguousReference(m)).findFirst().map(ReplaceLambdaByMethodRefCheck::getMethodReferenceFromSymbol);
    }

    private static boolean hasAmbiguousReference(Symbol.MethodSymbol ms) {
        return ((Symbol.TypeSymbol)ms.owner()).lookupSymbols(ms.name()).stream().filter(Symbol::isMethodSymbol).map(Symbol.MethodSymbol.class::cast).filter(m -> m.isStatic() != ms.isStatic()).anyMatch(m -> m.isStatic() ? ReplaceLambdaByMethodRefCheck.methodsHaveSameReference(m, ms) : ReplaceLambdaByMethodRefCheck.methodsHaveSameReference(ms, m));
    }

    private static boolean methodsHaveSameReference(Symbol.MethodSymbol mStatic, Symbol.MethodSymbol mNotStatic) {
        Type ownerType = mStatic.owner().type();
        return mStatic.parameterTypes().size() == mNotStatic.parameterTypes().size() + 1 && ReplaceLambdaByMethodRefCheck.isArgumentCompatible(ownerType, (Type)mStatic.parameterTypes().get(0));
    }

    private static Optional<String> getNewClass(NewClassTree newClassTree, List<VariableTree> parameters) {
        TypeTree identifier;
        if (newClassTree.classBody() == null && ReplaceLambdaByMethodRefCheck.matchingParameters(newClassTree.arguments(), parameters) && (identifier = newClassTree.identifier()).is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT, Tree.Kind.IDENTIFIER})) {
            String className = ExpressionsHelper.concatenate((ExpressionTree)identifier);
            return Optional.of(className + "::new");
        }
        return Optional.empty();
    }

    private static Optional<String> getReplacementForMethodInvocation(MethodInvocationTree mit) {
        ExpressionTree methodSelect = mit.methodSelect();
        Symbol.MethodSymbol symbol = mit.methodSymbol();
        if (symbol.isStatic()) {
            return ReplaceLambdaByMethodRefCheck.getUnambiguousReference(mit);
        }
        if (methodSelect.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            Symbol expressionOwner;
            MethodTree enclosingMethod = ExpressionUtils.getEnclosingMethod((ExpressionTree)mit);
            Symbol symbolOwner = symbol.owner();
            if (enclosingMethod != null && symbolOwner.equals((Object)(expressionOwner = enclosingMethod.symbol().owner()))) {
                return Optional.of("this::" + symbol.name());
            }
            return Optional.of(symbolOwner.name() + ".this::" + symbol.name());
        }
        MemberSelectExpressionTree memberSelect = (MemberSelectExpressionTree)methodSelect;
        return Optional.of(ExpressionsHelper.concatenate(memberSelect.expression()) + "::" + memberSelect.identifier().name());
    }

    private static String getMethodReferenceFromSymbol(Symbol symbol) {
        return symbol.owner().name() + "::" + symbol.name();
    }

    private static boolean hasMethodInvocationInMethodSelect(MethodInvocationTree mit) {
        MemberSelectExpressionTree mse = ReplaceLambdaByMethodRefCheck.getMemberSelect(mit);
        while (mse != null) {
            ExpressionTree expression = mse.expression();
            if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS})) {
                return true;
            }
            if (expression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                mse = (MemberSelectExpressionTree)expression;
                continue;
            }
            mse = null;
        }
        return false;
    }

    @CheckForNull
    private static MemberSelectExpressionTree getMemberSelect(MethodInvocationTree mit) {
        ExpressionTree methodSelect = mit.methodSelect();
        if (!methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return null;
        }
        return (MemberSelectExpressionTree)methodSelect;
    }

    private static boolean hasNonFinalFieldInMethodSelect(MethodInvocationTree mit) {
        MemberSelectExpressionTree mse = ReplaceLambdaByMethodRefCheck.getMemberSelect(mit);
        if (mse == null) {
            return false;
        }
        ExpressionTree expression = ExpressionUtils.skipParentheses((ExpressionTree)mse.expression());
        Symbol symbol = null;
        if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            symbol = ((IdentifierTree)expression).symbol();
        } else if (expression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            symbol = ((MemberSelectExpressionTree)expression).identifier().symbol();
        }
        return symbol != null && symbol.owner().isTypeSymbol() && !ReplaceLambdaByMethodRefCheck.isThisOrSuper(symbol.name()) && !symbol.isFinal();
    }

    private static boolean isThisOrSuper(String name) {
        return "this".equals(name) || "super".equals(name);
    }

    private static boolean matchingParameters(Arguments arguments, List<VariableTree> parameters) {
        return arguments.size() == parameters.size() && IntStream.range(0, arguments.size()).allMatch(i -> {
            List usages = ((VariableTree)parameters.get(i)).symbol().usages();
            return usages.size() == 1 && ((IdentifierTree)usages.get(0)).equals(arguments.get(i));
        });
    }

    private static boolean isMethodCalledOnFirstParam(MethodInvocationTree mit, List<VariableTree> parameters) {
        if (!parameters.isEmpty() && mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            ExpressionTree expression = ((MemberSelectExpressionTree)mit.methodSelect()).expression();
            Symbol parameterSymbol = parameters.get(0).symbol();
            return expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && !parameterSymbol.isUnknown() && parameterSymbol.equals((Object)((IdentifierTree)expression).symbol()) && ReplaceLambdaByMethodRefCheck.matchingParameters(mit.arguments(), parameters.subList(1, parameters.size()));
        }
        return false;
    }

    public static Optional<ExpressionTree> expressionWithoutParentheses(@Nullable Tree tree) {
        if (!(tree instanceof ExpressionTree)) {
            return Optional.empty();
        }
        ExpressionTree result = (ExpressionTree)tree;
        return Optional.of(ExpressionUtils.skipParentheses((ExpressionTree)result));
    }

    private static boolean isArgumentCompatible(Type argumentType, Type parameterType) {
        return argumentType.isSubtypeOf(parameterType) || JUtils.wrapTypeIfPrimitive((Type)argumentType).equals((Object)JUtils.wrapTypeIfPrimitive((Type)parameterType));
    }
}

