/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6104")
public class NullReturnedOnComputeIfPresentOrAbsentCheck
extends AbstractMethodDetection {
    private static final String PRIMARY_MESSAGE = "Use \"Map.containsKey(key)\" followed by \"Map.put(key, null)\" to add null values.";
    private static final String SECONDARY_MESSAGE = "null literal in the arguments";
    private static final MethodMatchers COMPUTE_IF = MethodMatchers.create().ofTypes(new String[]{"java.util.Map"}).names(new String[]{"computeIfPresent", "computeIfAbsent"}).addParametersMatcher(new String[]{"*", "*"}).build();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return COMPUTE_IF;
    }

    @Override
    public void onMethodInvocationFound(MethodInvocationTree invocation) {
        Arguments arguments = invocation.arguments();
        NullReturnedOnComputeIfPresentOrAbsentCheck.getNullReturnInLambda((Tree)arguments.get(1)).ifPresent(nullReturn -> this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)invocation), PRIMARY_MESSAGE, Collections.singletonList(new JavaFileScannerContext.Location(SECONDARY_MESSAGE, nullReturn)), null));
    }

    private static Optional<Tree> getNullReturnInLambda(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.LAMBDA_EXPRESSION})) {
            Tree body = ((LambdaExpressionTree)tree).body();
            if (body.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL})) {
                return Optional.of(body);
            }
        }
        return Optional.empty();
    }
}

