/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S3014")
public class DisallowedThreadGroupCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String JAVA_LANG_THREADGROUP = "java.lang.ThreadGroup";
    private static final String MESSAGE = "Remove this use of \"ThreadGroup\". Prefer the use of \"ThreadPoolExecutor\".";
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        if (context.getSemanticModel() == null) {
            return;
        }
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        TypeTree superClass = tree.superClass();
        if (superClass != null && superClass.symbolType().is(JAVA_LANG_THREADGROUP)) {
            this.context.reportIssue((JavaCheck)this, (Tree)superClass, MESSAGE);
        }
        super.visitClass(tree);
    }

    public void visitMethod(MethodTree tree) {
        boolean notOverriding = Boolean.FALSE.equals(tree.isOverriding());
        boolean reported = false;
        boolean declaresThreadGroup = false;
        TypeTree returnType = tree.returnType();
        if (returnType != null && returnType.symbolType().is(JAVA_LANG_THREADGROUP)) {
            if (notOverriding) {
                this.context.reportIssue((JavaCheck)this, (Tree)returnType, MESSAGE);
                reported = true;
            }
            declaresThreadGroup = true;
        }
        for (VariableTree variableTree : tree.parameters()) {
            TypeTree type = variableTree.type();
            if (!type.symbolType().is(JAVA_LANG_THREADGROUP)) continue;
            if (notOverriding) {
                this.context.reportIssue((JavaCheck)this, (Tree)type, MESSAGE);
                reported = true;
            }
            declaresThreadGroup = true;
        }
        if (declaresThreadGroup && !reported) {
            return;
        }
        super.scan((Tree)tree.block());
    }

    public void visitVariable(VariableTree tree) {
        TypeTree type = tree.type();
        if (type.symbolType().is(JAVA_LANG_THREADGROUP)) {
            this.context.reportIssue((JavaCheck)this, (Tree)type, MESSAGE);
        }
        super.visitVariable(tree);
    }
}

