/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;

@Rule(key="S1943")
public class DefaultEncodingUsageCheck
extends AbstractMethodDetection
implements JavaVersionAwareVisitor {
    private static final String INT = "int";
    private static final String BOOLEAN = "boolean";
    private static final String BYTE_ARRAY = "byte[]";
    private static final String TO_STRING = "toString";
    private static final String WRITE = "write";
    private static final String JAVA_IO_FILE = "java.io.File";
    private static final String JAVA_IO_FILEDESCRIPTOR = "java.io.FileDescriptor";
    private static final String JAVA_IO_READER = "java.io.Reader";
    private static final String JAVA_IO_WRITER = "java.io.Writer";
    private static final String JAVA_IO_FILEWRITER = "java.io.FileWriter";
    private static final String JAVA_IO_FILEREADER = "java.io.FileReader";
    private static final String JAVA_IO_PRINTWRITER = "java.io.PrintWriter";
    private static final String JAVA_IO_PRINTSTREAM = "java.io.PrintStream";
    private static final String JAVA_IO_INPUTSTREAM = "java.io.InputStream";
    private static final String JAVA_IO_OUTPUTSTREAM = "java.io.OutputStream";
    private static final String JAVA_IO_BYTEARRAYOUTPUTSTREAM = "java.io.ByteArrayOutputStream";
    private static final String JAVA_IO_OUTPUTSTREAMWRITER = "java.io.OutputStreamWriter";
    private static final String JAVA_IO_INPUTSTREAMREADER = "java.io.InputStreamReader";
    private static final String JAVA_NIO_FILE_PATH = "java.nio.file.Path";
    private static final String JAVA_NIO_CHARSET = "java.nio.charset.Charset";
    private static final String JAVA_LANG_CHARSEQUENCE = "java.lang.CharSequence";
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String JAVA_UTIL_SCANNER = "java.util.Scanner";
    private static final String JAVA_UTIL_FORMATTER = "java.util.Formatter";
    private static final String COMMONS_IOUTILS = "org.apache.commons.io.IOUtils";
    private static final String COMMONS_FILEUTILS = "org.apache.commons.io.FileUtils";
    private static final List<MethodMatchers> COMMONS_IO = new ArrayList<MethodMatchers>();
    private static final List<MethodMatchers> COMMONS_IO_WITH_CHARSET = new ArrayList<MethodMatchers>();
    private static final MethodMatchers COMMONS_IO_CHARSET_MATCHERS;
    private static final MethodMatchers FILEUTILS_WRITE_WITH_CHARSET;
    private static final MethodMatchers FILEUTILS_WRITE_WITH_CHARSET_MATCHERS;

    private static void withAndWithoutCharset(String type, String methodName, String ... parameters) {
        MethodMatchers.ParametersBuilder nameBuilder = MethodMatchers.create().ofTypes(new String[]{type}).names(new String[]{methodName});
        COMMONS_IO.add(nameBuilder.addParametersMatcher(parameters).build());
        int originalSize = parameters.length;
        String[] copy = Arrays.copyOf(parameters, originalSize + 1);
        copy[originalSize] = JAVA_LANG_STRING;
        COMMONS_IO_WITH_CHARSET.add(nameBuilder.addParametersMatcher(copy).build());
        copy[originalSize] = JAVA_NIO_CHARSET;
        COMMONS_IO_WITH_CHARSET.add(nameBuilder.addParametersMatcher(copy).build());
    }

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isSet() && version.asInt() < 18;
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS);
    }

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        ArrayList<MethodMatchers> matchers = new ArrayList<MethodMatchers>(Arrays.asList(MethodMatchers.create().ofTypes(new String[]{JAVA_LANG_STRING}).names(new String[]{"getBytes"}).addWithoutParametersMatcher().addParametersMatcher(new String[]{INT, INT, BYTE_ARRAY, INT}).build(), MethodMatchers.create().ofTypes(new String[]{JAVA_LANG_STRING}).constructor().addParametersMatcher(new String[]{BYTE_ARRAY}).addParametersMatcher(new String[]{BYTE_ARRAY, INT, INT}).build(), MethodMatchers.create().ofTypes(new String[]{JAVA_IO_BYTEARRAYOUTPUTSTREAM}).names(new String[]{TO_STRING}).addWithoutParametersMatcher().build(), MethodMatchers.create().ofTypes(new String[]{JAVA_IO_FILEREADER}).constructor().addParametersMatcher(new String[]{JAVA_IO_FILE}).addParametersMatcher(new String[]{JAVA_IO_FILEDESCRIPTOR}).addParametersMatcher(new String[]{JAVA_LANG_STRING}).build(), MethodMatchers.create().ofTypes(new String[]{JAVA_IO_FILEWRITER}).constructor().addParametersMatcher(new String[]{JAVA_IO_FILE}).addParametersMatcher(new String[]{JAVA_IO_FILEDESCRIPTOR}).addParametersMatcher(new String[]{JAVA_IO_FILE, BOOLEAN}).addParametersMatcher(new String[]{JAVA_LANG_STRING}).addParametersMatcher(new String[]{JAVA_LANG_STRING, BOOLEAN}).build(), MethodMatchers.create().ofTypes(new String[]{JAVA_IO_INPUTSTREAMREADER}).constructor().addParametersMatcher(new String[]{JAVA_IO_INPUTSTREAM}).build(), MethodMatchers.create().ofTypes(new String[]{JAVA_IO_OUTPUTSTREAMWRITER}).constructor().addParametersMatcher(new String[]{JAVA_IO_OUTPUTSTREAM}).build(), MethodMatchers.create().ofTypes(new String[]{JAVA_IO_PRINTSTREAM}).constructor().addParametersMatcher(new String[]{JAVA_IO_FILE}).addParametersMatcher(new String[]{JAVA_IO_OUTPUTSTREAM}).addParametersMatcher(new String[]{JAVA_IO_OUTPUTSTREAM, BOOLEAN}).addParametersMatcher(new String[]{JAVA_LANG_STRING}).build(), MethodMatchers.create().ofTypes(new String[]{JAVA_IO_PRINTWRITER}).constructor().addParametersMatcher(new String[]{JAVA_IO_FILE}).addParametersMatcher(new String[]{JAVA_IO_OUTPUTSTREAM}).addParametersMatcher(new String[]{JAVA_IO_OUTPUTSTREAM, BOOLEAN}).addParametersMatcher(new String[]{JAVA_LANG_STRING}).build(), MethodMatchers.create().ofTypes(new String[]{JAVA_UTIL_FORMATTER}).constructor().addParametersMatcher(new String[]{JAVA_LANG_STRING}).addParametersMatcher(new String[]{JAVA_IO_FILE}).addParametersMatcher(new String[]{JAVA_IO_OUTPUTSTREAM}).build(), MethodMatchers.create().ofTypes(new String[]{JAVA_UTIL_SCANNER}).constructor().addParametersMatcher(new String[]{JAVA_IO_FILE}).addParametersMatcher(new String[]{JAVA_NIO_FILE_PATH}).addParametersMatcher(new String[]{JAVA_IO_INPUTSTREAM}).build()));
        matchers.addAll(COMMONS_IO);
        matchers.addAll(COMMONS_IO_WITH_CHARSET);
        matchers.add(FILEUTILS_WRITE_WITH_CHARSET);
        return MethodMatchers.or(matchers);
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (COMMONS_IO_CHARSET_MATCHERS.matches(mit)) {
            Arguments arguments = mit.arguments();
            ExpressionTree lastArgument = (ExpressionTree)arguments.get(arguments.size() - 1);
            this.testNullLiteralPassedForEncoding(lastArgument);
        } else if (FILEUTILS_WRITE_WITH_CHARSET_MATCHERS.matches(mit)) {
            this.testNullLiteralPassedForEncoding((ExpressionTree)mit.arguments().get(2));
        } else {
            this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), "Remove this use of \"" + mit.methodSymbol().name() + "\".");
        }
    }

    private void testNullLiteralPassedForEncoding(ExpressionTree argument) {
        if (DefaultEncodingUsageCheck.isNullLiteral(argument)) {
            this.reportIssue((Tree)argument, "Replace this \"null\" with actual charset.");
        }
    }

    private static boolean isNullLiteral(ExpressionTree lastArgument) {
        ExpressionTree arg = ExpressionUtils.skipParentheses((ExpressionTree)lastArgument);
        return arg.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL}) || arg.is(new Tree.Kind[]{Tree.Kind.TYPE_CAST}) && DefaultEncodingUsageCheck.isNullLiteral(((TypeCastTree)arg).expression());
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        Symbol.MethodSymbol symbol = newClassTree.methodSymbol();
        if (!symbol.isUnknown()) {
            String signature = symbol.owner().name() + "(" + symbol.parameterTypes().stream().map(Type::toString).collect(Collectors.joining(",")) + ")";
            this.reportIssue((Tree)newClassTree.identifier(), "Remove this use of constructor \"" + signature + "\".");
        }
    }

    static {
        DefaultEncodingUsageCheck.withAndWithoutCharset(COMMONS_IOUTILS, "copy", JAVA_IO_INPUTSTREAM, JAVA_IO_WRITER);
        DefaultEncodingUsageCheck.withAndWithoutCharset(COMMONS_IOUTILS, "copy", JAVA_IO_READER, JAVA_IO_OUTPUTSTREAM);
        DefaultEncodingUsageCheck.withAndWithoutCharset(COMMONS_IOUTILS, "readLines", JAVA_IO_INPUTSTREAM);
        DefaultEncodingUsageCheck.withAndWithoutCharset(COMMONS_IOUTILS, "toByteArray", JAVA_IO_READER);
        DefaultEncodingUsageCheck.withAndWithoutCharset(COMMONS_IOUTILS, "toCharArray", JAVA_IO_INPUTSTREAM);
        DefaultEncodingUsageCheck.withAndWithoutCharset(COMMONS_IOUTILS, "toInputStream", JAVA_LANG_CHARSEQUENCE);
        DefaultEncodingUsageCheck.withAndWithoutCharset(COMMONS_IOUTILS, "toInputStream", JAVA_LANG_STRING);
        DefaultEncodingUsageCheck.withAndWithoutCharset(COMMONS_IOUTILS, TO_STRING, BYTE_ARRAY);
        DefaultEncodingUsageCheck.withAndWithoutCharset(COMMONS_IOUTILS, TO_STRING, "java.net.URI");
        DefaultEncodingUsageCheck.withAndWithoutCharset(COMMONS_IOUTILS, TO_STRING, "java.net.URL");
        DefaultEncodingUsageCheck.withAndWithoutCharset(COMMONS_IOUTILS, WRITE, "char[]", JAVA_IO_OUTPUTSTREAM);
        DefaultEncodingUsageCheck.withAndWithoutCharset(COMMONS_IOUTILS, "writeLines", "java.util.Collection", JAVA_LANG_STRING, JAVA_IO_OUTPUTSTREAM);
        DefaultEncodingUsageCheck.withAndWithoutCharset(COMMONS_FILEUTILS, "readFileToString", JAVA_IO_FILE);
        DefaultEncodingUsageCheck.withAndWithoutCharset(COMMONS_FILEUTILS, "readLines", JAVA_IO_FILE);
        DefaultEncodingUsageCheck.withAndWithoutCharset(COMMONS_FILEUTILS, WRITE, JAVA_IO_FILE, JAVA_LANG_CHARSEQUENCE);
        DefaultEncodingUsageCheck.withAndWithoutCharset(COMMONS_FILEUTILS, WRITE, JAVA_IO_FILE, JAVA_LANG_CHARSEQUENCE, BOOLEAN);
        DefaultEncodingUsageCheck.withAndWithoutCharset(COMMONS_FILEUTILS, "writeStringToFile", JAVA_IO_FILE, JAVA_LANG_STRING);
        MethodMatchers.ParametersBuilder parametersBuilder = MethodMatchers.create().ofTypes(new String[]{COMMONS_IOUTILS}).names(new String[]{WRITE});
        COMMONS_IO.add(parametersBuilder.addParametersMatcher(params -> params.size() == 2 && ((Type)params.get(0)).isSubtypeOf(JAVA_LANG_CHARSEQUENCE) && ((Type)params.get(1)).is(JAVA_IO_OUTPUTSTREAM)).build());
        COMMONS_IO_WITH_CHARSET.add(parametersBuilder.addParametersMatcher(params -> params.size() == 3 && ((Type)params.get(0)).isSubtypeOf(JAVA_LANG_CHARSEQUENCE) && ((Type)params.get(1)).is(JAVA_IO_OUTPUTSTREAM) && (((Type)params.get(2)).is(JAVA_NIO_CHARSET) || ((Type)params.get(2)).is(JAVA_LANG_STRING))).build());
        COMMONS_IO_CHARSET_MATCHERS = MethodMatchers.or(COMMONS_IO_WITH_CHARSET);
        FILEUTILS_WRITE_WITH_CHARSET = MethodMatchers.create().ofTypes(new String[]{COMMONS_FILEUTILS}).names(new String[]{WRITE}).addParametersMatcher(new String[]{JAVA_IO_FILE, JAVA_LANG_CHARSEQUENCE, JAVA_LANG_STRING, BOOLEAN}).addParametersMatcher(new String[]{JAVA_IO_FILE, JAVA_LANG_CHARSEQUENCE, JAVA_NIO_CHARSET, BOOLEAN}).build();
        FILEUTILS_WRITE_WITH_CHARSET_MATCHERS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{FILEUTILS_WRITE_WITH_CHARSET});
    }
}

