/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.checks.CompareWithEqualsVisitor;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4973")
public class CompareStringsBoxedTypesWithEqualsCheck
extends CompareWithEqualsVisitor {
    private static final String ISSUE_MESSAGE = "Strings and Boxed types should be compared using \"equals()\".";
    private static final String QUICK_FIX_MESSAGE = "Replace with boxed comparison";
    private static final String DOT_EQUALS_AND_OPENING_PARENTHESIS = ".equals(";
    private QuickFixHelper.ImportSupplier importSupplier;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.importSupplier = null;
        super.scanFile(context);
    }

    @Override
    protected void checkEqualityExpression(BinaryExpressionTree tree) {
        Type rightOpType;
        Type leftOpType = tree.leftOperand().symbolType();
        if (!CompareStringsBoxedTypesWithEqualsCheck.isNullComparison(leftOpType, rightOpType = tree.rightOperand().symbolType()) && !CompareStringsBoxedTypesWithEqualsCheck.isCompareWithBooleanConstant(tree.leftOperand(), tree.rightOperand()) && (CompareStringsBoxedTypesWithEqualsCheck.isStringType(leftOpType, rightOpType) || CompareStringsBoxedTypesWithEqualsCheck.isBoxedType(leftOpType, rightOpType))) {
            QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)tree.operatorToken()).withMessage(ISSUE_MESSAGE).withQuickFix(() -> CompareStringsBoxedTypesWithEqualsCheck.computeConciseQuickFix(tree).orElseGet(() -> this.computeDefaultQuickFix(tree))).report();
        }
    }

    private static boolean isCompareWithBooleanConstant(ExpressionTree left, ExpressionTree right) {
        return ExpressionsHelper.getConstantValueAsBoolean(left).value() != null || ExpressionsHelper.getConstantValueAsBoolean(right).value() != null;
    }

    private static Optional<JavaQuickFix> computeConciseQuickFix(BinaryExpressionTree tree) {
        ExpressionTree leftOperand = tree.leftOperand();
        ExpressionTree rightOperand = tree.rightOperand();
        if (leftOperand.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            AnalyzerMessage.TextSpan interOperandSpace = AnalyzerMessage.textSpanBetween((Tree)leftOperand, (boolean)false, (Tree)rightOperand, (boolean)false);
            JavaQuickFix.Builder quickFix = JavaQuickFix.newQuickFix((String)QUICK_FIX_MESSAGE).addTextEdit(new JavaTextEdit[]{JavaTextEdit.insertAfterTree((Tree)rightOperand, (String)")")}).addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTextSpan((AnalyzerMessage.TextSpan)interOperandSpace, (String)DOT_EQUALS_AND_OPENING_PARENTHESIS)});
            if (tree.is(new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO})) {
                quickFix.addTextEdit(new JavaTextEdit[]{JavaTextEdit.insertBeforeTree((Tree)leftOperand, (String)"!")});
            }
            return Optional.of(quickFix.build());
        }
        if (rightOperand.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            String callEqualsOnLiteral = ((LiteralTree)rightOperand).value() + DOT_EQUALS_AND_OPENING_PARENTHESIS;
            String callToEquals = tree.is(new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO}) ? "!" + callEqualsOnLiteral : callEqualsOnLiteral;
            AnalyzerMessage.TextSpan leftOfOperatorToEndOfComparison = AnalyzerMessage.textSpanBetween((Tree)leftOperand, (boolean)false, (Tree)rightOperand, (boolean)true);
            return Optional.of(JavaQuickFix.newQuickFix((String)QUICK_FIX_MESSAGE).addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTextSpan((AnalyzerMessage.TextSpan)leftOfOperatorToEndOfComparison, (String)")")}).addTextEdit(new JavaTextEdit[]{JavaTextEdit.insertBeforeTree((Tree)leftOperand, (String)callToEquals)}).build());
        }
        return Optional.empty();
    }

    private JavaQuickFix computeDefaultQuickFix(BinaryExpressionTree tree) {
        String callToEquals = tree.is(new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO}) ? "!Objects.equals(" : "Objects.equals(";
        AnalyzerMessage.TextSpan interOperandSpace = AnalyzerMessage.textSpanBetween((Tree)tree.leftOperand(), (boolean)false, (Tree)tree.rightOperand(), (boolean)false);
        JavaQuickFix.Builder builder = JavaQuickFix.newQuickFix((String)QUICK_FIX_MESSAGE).addTextEdit(new JavaTextEdit[]{JavaTextEdit.insertAfterTree((Tree)tree.rightOperand(), (String)")")}).addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTextSpan((AnalyzerMessage.TextSpan)interOperandSpace, (String)", ")}).addTextEdit(new JavaTextEdit[]{JavaTextEdit.insertBeforeTree((Tree)tree.leftOperand(), (String)callToEquals)});
        if (this.importSupplier == null) {
            this.importSupplier = QuickFixHelper.newImportSupplier(this.context);
        }
        this.importSupplier.newImportEdit("java.util.Objects").ifPresent(xva$0 -> builder.addTextEdit(new JavaTextEdit[]{xva$0}));
        return builder.build();
    }
}

