/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1157")
public class CaseInsensitiveComparisonCheck
extends AbstractMethodDetection {
    private static final MethodMatchers TO_LOWER_UPPER_CASE = MethodMatchers.create().ofSubTypes(new String[]{"java.lang.String"}).names(new String[]{"toLowerCase", "toUpperCase"}).addWithoutParametersMatcher().build();

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofAnyType().names(new String[]{"equals"}).addParametersMatcher(new String[]{"java.lang.Object"}).build();
    }

    @Override
    public void onMethodInvocationFound(MethodInvocationTree tree) {
        MemberSelectExpressionTree memberSelect;
        if (tree.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && CaseInsensitiveComparisonCheck.ignoresCase((memberSelect = (MemberSelectExpressionTree)tree.methodSelect()).expression(), (ExpressionTree)tree.arguments().get(0))) {
            this.reportIssue((Tree)tree, "Replace these toUpperCase()/toLowerCase() and equals() calls with a single equalsIgnoreCase() call.");
        }
    }

    private static boolean ignoresCase(ExpressionTree lhs, ExpressionTree rhs) {
        boolean lhsConverted = CaseInsensitiveComparisonCheck.isToUpperCaseOrToLowerCase(lhs);
        boolean rhsConverted = CaseInsensitiveComparisonCheck.isToUpperCaseOrToLowerCase(rhs);
        return lhsConverted && (rhsConverted || CaseInsensitiveComparisonCheck.isStringConstant(rhs)) || rhsConverted && CaseInsensitiveComparisonCheck.isStringConstant(lhs);
    }

    private static boolean isStringConstant(ExpressionTree expression) {
        return expression.asConstant(String.class).isPresent();
    }

    private static boolean isToUpperCaseOrToLowerCase(ExpressionTree expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree methodInvocation = (MethodInvocationTree)expression;
            return TO_LOWER_UPPER_CASE.matches(methodInvocation);
        }
        return false;
    }
}

