/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.ArrayDesignatorOnVariableCheck;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1195")
public class ArrayDesignatorAfterTypeCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        ArrayDesignatorOnVariableCheck.MisplacedArray.find(methodTree.returnType(), methodTree.simpleName().identifierToken()).ifPresent(misplaced -> QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onRange((Tree)misplaced.firstArray.openBracketToken(), (Tree)misplaced.lastArray.closeBracketToken()).withMessage("Move the array designators " + misplaced.replacement + " to the end of the return type.").withQuickFix(() -> ArrayDesignatorOnVariableCheck.createQuickFix(misplaced, "return type")).report());
    }
}

