/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.unused;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeParameterTree;
import org.sonar.plugins.java.api.tree.TypeParameters;

@Rule(key="S2326")
public class UnusedTypeParameterCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.INTERFACE, Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        String messageEnd;
        TypeParameters typeParameters;
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            typeParameters = ((MethodTree)tree).typeParameters();
            messageEnd = "method.";
        } else {
            typeParameters = ((ClassTree)tree).typeParameters();
            messageEnd = "class.";
            if (tree.is(new Tree.Kind[]{Tree.Kind.INTERFACE})) {
                messageEnd = "interface.";
            }
        }
        for (TypeParameterTree typeParameter : typeParameters) {
            Symbol symbol = JUtils.typeParameterTreeSymbol((TypeParameterTree)typeParameter);
            if (symbol.isUnknown() || !symbol.usages().isEmpty()) continue;
            String message = typeParameter.identifier().name() + " is not used in the " + messageEnd;
            this.reportIssue((Tree)typeParameter.identifier(), message);
        }
    }
}

