/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.collections.SetUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5967")
public class JUnitCompatibleAnnotationsCheck
extends IssuableSubscriptionVisitor {
    private static final Set<String> ANNOTATIONS = SetUtils.immutableSetOf((Object[])new String[]{"org.junit.jupiter.api.Test", "org.junit.jupiter.api.RepeatedTest", "org.junit.jupiter.api.TestFactory", "org.junit.jupiter.api.TestTemplate", "org.junit.jupiter.params.ParameterizedTest"});

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree method = (MethodTree)tree;
        List annotationTrees = method.modifiers().annotations();
        List locations = annotationTrees.stream().filter(annotation -> ANNOTATIONS.contains(annotation.annotationType().symbolType().fullyQualifiedName())).map(annotationTree -> new JavaFileScannerContext.Location("Incompatible annotation", (Tree)annotationTree)).collect(Collectors.toList());
        if (locations.size() > 1) {
            this.reportIssue((Tree)method.simpleName(), "Remove one of these conflicting annotations.", locations, null);
        }
    }
}

