/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.checks.helpers.UnitTestUtils;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JUtils;
import org.sonar.java.model.Symbols;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5845")
public class AssertionTypesCheck
extends IssuableSubscriptionVisitor {
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private static final String JUNIT4_ASSERTIONS = "org.junit.Assert";
    private static final String JUNIT5_ASSERTIONS = "org.junit.jupiter.api.Assertions";
    private static final String ASSERT_NULL = "assertNull";
    private static final String ASSERT_NOT_NULL = "assertNotNull";
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String ASSERT_EQUALS = "assertEquals";
    private static final String ASSERT_NOT_EQUALS = "assertNotEquals";
    private static final MethodMatchers ASSERT_NULLABLE_FIRST_ARGUMENT = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"org.junit.Assert"}).names(new String[]{"assertNull", "assertNotNull"}).addParametersMatcher(new String[]{"*"}).build(), MethodMatchers.create().ofTypes(new String[]{"org.junit.jupiter.api.Assertions"}).names(new String[]{"assertNull", "assertNotNull"}).addParametersMatcher(new String[]{"*"}).addParametersMatcher(new String[]{"*", "*"}).build()});
    private static final MethodMatchers ASSERT_NULLABLE_SECOND_ARGUMENT = MethodMatchers.create().ofTypes(new String[]{"org.junit.Assert"}).names(new String[]{"assertNull", "assertNotNull"}).addParametersMatcher(new String[]{"java.lang.String", "*"}).build();
    private static final MethodMatchers ASSERT_EQUALS_FIRST_AND_SECOND_ARGUMENTS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"org.junit.Assert"}).names(new String[]{"assertEquals"}).addParametersMatcher(new String[]{"*", "*"}).build(), MethodMatchers.create().ofTypes(new String[]{"org.junit.jupiter.api.Assertions"}).names(new String[]{"assertEquals"}).addParametersMatcher(new String[]{"*", "*"}).addParametersMatcher(new String[]{"*", "*", "*"}).addParametersMatcher(new String[]{"*", "*", "*", "*"}).build()});
    private static final MethodMatchers ASSERT_EQUALS_SECOND_AND_THIRD_ARGUMENTS = MethodMatchers.create().ofTypes(new String[]{"org.junit.Assert"}).names(new String[]{"assertEquals"}).addParametersMatcher(new String[]{"java.lang.String", "*", "*"}).addParametersMatcher(new String[]{"java.lang.String", "*", "*", "*"}).build();
    private static final MethodMatchers ASSERT_NOT_EQUALS_FIRST_AND_SECOND_ARGUMENTS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"org.junit.Assert"}).names(new String[]{"assertNotEquals"}).addParametersMatcher(new String[]{"*", "*"}).build(), MethodMatchers.create().ofTypes(new String[]{"org.junit.jupiter.api.Assertions"}).names(new String[]{"assertNotEquals"}).addParametersMatcher(new String[]{"*", "*"}).addParametersMatcher(new String[]{"*", "*", "*"}).addParametersMatcher(new String[]{"*", "*", "*", "*"}).build()});
    private static final MethodMatchers ASSERT_NOT_EQUALS_SECOND_AND_THIRD_ARGUMENTS = MethodMatchers.create().ofTypes(new String[]{"org.junit.Assert"}).names(new String[]{"assertNotEquals"}).addParametersMatcher(new String[]{"java.lang.String", "*", "*"}).addParametersMatcher(new String[]{"java.lang.String", "*", "*", "*"}).build();
    private static final MethodMatchers ASSERTJ_ASSERT_THAT = MethodMatchers.create().ofTypes(new String[]{"org.assertj.core.api.Assertions", "org.assertj.core.api.AssertionsForInterfaceTypes", "org.assertj.core.api.AssertionsForClassTypes"}).names(new String[]{"assertThat", "assertThatObject"}).addParametersMatcher(new String[]{"*"}).build();
    private static final MethodMatchers.NameBuilder MATCHER_ANY_TYPE = MethodMatchers.create().ofAnyType();
    private static final MethodMatchers ASSERTJ_NULL_AND_NOT_NULL = MATCHER_ANY_TYPE.names(new String[]{"isNull", "isNotNull"}).addWithoutParametersMatcher().build();
    private static final MethodMatchers ASSERTJ_EQUAL_TO_PREDICATE = MATCHER_ANY_TYPE.names(new String[]{"isEqualTo"}).addParametersMatcher(new String[]{"*"}).build();
    private static final MethodMatchers ASSERTJ_IS_SAME_AS_PREDICATE = MATCHER_ANY_TYPE.names(new String[]{"isSameAs"}).addParametersMatcher(new String[]{"*"}).build();
    private static final MethodMatchers ASSERTJ_IS_NOT_EQUAL_TO_PREDICATE = MATCHER_ANY_TYPE.names(new String[]{"isNotEqualTo"}).addParametersMatcher(new String[]{"*"}).build();
    private static final MethodMatchers ASSERTJ_IS_NOT_SAME_AS_PREDICATE = MATCHER_ANY_TYPE.names(new String[]{"isNotSameAs"}).addParametersMatcher(new String[]{"*"}).build();
    private static final MethodMatchers ASSERTJ_CONFIGURATION = MATCHER_ANY_TYPE.names(new String[]{"as", "describedAs", "withFailMessage", "overridingErrorMessage"}).withAnyParameters().build();
    private static final List<String> ASSERTJ_EXCEPTIONS = Arrays.asList("org.assertj.core.api.AbstractTemporalAssert", "org.assertj.core.api.AbstractDateAssert", "org.assertj.core.api.AbstractBigIntegerAssert", "org.assertj.core.api.AbstractBigDecimalAssert");

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        MethodInvocationTree mit = (MethodInvocationTree)tree;
        if (ASSERT_NULLABLE_FIRST_ARGUMENT.matches(mit)) {
            this.checkNullableAssertion(new Argument(mit, 0));
        } else if (ASSERT_NULLABLE_SECOND_ARGUMENT.matches(mit)) {
            this.checkNullableAssertion(new Argument(mit, 1));
        } else if (ASSERT_EQUALS_FIRST_AND_SECOND_ARGUMENTS.matches(mit)) {
            this.checkCompatibleTypes(mit, new Argument(mit, 1), new Argument(mit, 0), Option.ACCEPT_DISSIMILAR_INTERFACE);
        } else if (ASSERT_EQUALS_SECOND_AND_THIRD_ARGUMENTS.matches(mit)) {
            this.checkCompatibleTypes(mit, new Argument(mit, 2), new Argument(mit, 1), Option.ACCEPT_DISSIMILAR_INTERFACE);
        } else if (ASSERT_NOT_EQUALS_FIRST_AND_SECOND_ARGUMENTS.matches(mit)) {
            this.checkCompatibleTypes(mit, new Argument(mit, 1), new Argument(mit, 0), Option.REJECT_DISSIMILAR_INTERFACE);
        } else if (ASSERT_NOT_EQUALS_SECOND_AND_THIRD_ARGUMENTS.matches(mit)) {
            this.checkCompatibleTypes(mit, new Argument(mit, 2), new Argument(mit, 1), Option.REJECT_DISSIMILAR_INTERFACE);
        } else if (ASSERTJ_ASSERT_THAT.matches(mit)) {
            this.checkSubsequentAssertJPredicateCompatibleTypes(new Argument(mit, 0), mit);
        }
    }

    private void checkSubsequentAssertJPredicateCompatibleTypes(Argument actual, MethodInvocationTree previousMethod) {
        MethodTreeUtils.consecutiveMethodInvocation((Tree)previousMethod).ifPresent(mit -> {
            boolean checkFollowingMethod = true;
            if (ASSERTJ_NULL_AND_NOT_NULL.matches(mit)) {
                this.checkNullableAssertion((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), actual);
            } else if (ASSERTJ_EQUAL_TO_PREDICATE.matches(mit)) {
                this.checkCompatibleAssertJEqualTypes((MethodInvocationTree)mit, actual, new Argument((MethodInvocationTree)mit, 0), Option.ACCEPT_DISSIMILAR_INTERFACE);
            } else if (ASSERTJ_IS_SAME_AS_PREDICATE.matches(mit)) {
                this.checkCompatibleTypes((MethodInvocationTree)mit, actual, new Argument((MethodInvocationTree)mit, 0), Option.ACCEPT_DISSIMILAR_INTERFACE);
            } else if (ASSERTJ_IS_NOT_EQUAL_TO_PREDICATE.matches(mit)) {
                this.checkCompatibleAssertJEqualTypes((MethodInvocationTree)mit, actual, new Argument((MethodInvocationTree)mit, 0), Option.REJECT_DISSIMILAR_INTERFACE);
            } else if (ASSERTJ_IS_NOT_SAME_AS_PREDICATE.matches(mit)) {
                this.checkCompatibleTypes((MethodInvocationTree)mit, actual, new Argument((MethodInvocationTree)mit, 0), Option.REJECT_DISSIMILAR_INTERFACE);
            } else if (!ASSERTJ_CONFIGURATION.matches(mit)) {
                checkFollowingMethod = false;
            }
            if (checkFollowingMethod) {
                this.checkSubsequentAssertJPredicateCompatibleTypes(actual, (MethodInvocationTree)mit);
            }
        });
    }

    private void checkNullableAssertion(Argument actual) {
        this.checkNullableAssertion((Tree)actual.expression, actual);
    }

    private void checkNullableAssertion(Tree issueLocation, Argument actual) {
        if (actual.isPrimitive()) {
            this.reportIssue(issueLocation, "Change the assertion arguments to not compare a primitive value with null.");
        }
    }

    private void checkCompatibleAssertJEqualTypes(MethodInvocationTree mit, Argument actual, Argument expected, Option option) {
        Type type = mit.symbolType();
        if (ASSERTJ_EXCEPTIONS.stream().anyMatch(arg_0 -> ((Type)type).isSubtypeOf(arg_0))) {
            return;
        }
        this.checkCompatibleTypes(mit, actual, expected, option);
    }

    private void checkCompatibleTypes(MethodInvocationTree mit, Argument actual, Argument expected, Option option) {
        if (AssertionTypesCheck.areNotCompatibleTypes(actual, expected, option) && !AssertionTypesCheck.isNotEqualsInTestRelatedToEquals(mit)) {
            this.createIssue(actual, expected);
        }
    }

    private static boolean isNotEqualsInTestRelatedToEquals(MethodInvocationTree mit) {
        String methodName = ExpressionUtils.methodName((MethodInvocationTree)mit).name();
        return (methodName.equals(ASSERT_NOT_EQUALS) || methodName.equals("isNotEqualTo")) && UnitTestUtils.isInUnitTestRelatedToObjectMethods((ExpressionTree)mit);
    }

    private static boolean areNotCompatibleTypes(Argument actual, Argument expected, Option option) {
        return AssertionTypesCheck.isNullAndPrimitive(actual, expected) || AssertionTypesCheck.isNotCompatibleArray(actual, expected, option) || AssertionTypesCheck.isArrayAndNotArray(actual, expected) || AssertionTypesCheck.isNotCompatibleClass(actual, expected, option);
    }

    private static boolean isNullAndPrimitive(Argument actual, Argument expected) {
        return actual.isNullLiteral() && expected.isPrimitive() || actual.isPrimitive() && expected.isNullLiteral();
    }

    private static boolean isArrayAndNotArray(Argument actual, Argument expected) {
        return actual.isArray() && expected.isNotArray() || actual.isNotArray() && expected.isArray();
    }

    private static boolean isNotCompatibleArray(Argument actual, Argument expected, Option option) {
        if (!actual.isArray() || !expected.isArray()) {
            return false;
        }
        Type actualElementType = ((Type.ArrayType)actual.type).elementType().erasure();
        Type expectedElementType = ((Type.ArrayType)expected.type).elementType().erasure();
        if (actualElementType.isUnknown() || expectedElementType.isUnknown()) {
            return false;
        }
        if (actualElementType.isPrimitive() || expectedElementType.isPrimitive()) {
            return !actualElementType.name().equals(expectedElementType.name());
        }
        return AssertionTypesCheck.areNotCompatibleTypes(new Argument(actual.expression, actualElementType), new Argument(expected.expression, expectedElementType), option);
    }

    private static boolean isNotCompatibleClass(Argument actual, Argument expected, Option option) {
        return AssertionTypesCheck.isNotInstanceOf(actual, expected, option) && AssertionTypesCheck.isNotInstanceOf(expected, actual, option);
    }

    private static boolean isNotInstanceOf(Argument argumentA, Argument argumentB, Option option) {
        if (argumentA.type.isPrimitive() && argumentB.type.isPrimitive()) {
            return false;
        }
        Type typeA = AssertionTypesCheck.wrapperType(argumentA.type);
        Type typeB = AssertionTypesCheck.wrapperType(argumentB.type);
        if (typeA.isUnknown() || typeB.isUnknown() || !typeA.isClass() || !typeB.isClass()) {
            return false;
        }
        if (typeA.symbol().isInterface() && typeB.symbol().isInterface()) {
            return option == Option.REJECT_DISSIMILAR_INTERFACE && !typeA.isSubtypeOf(typeB);
        }
        if (typeB.symbol().isInterface()) {
            return (option == Option.REJECT_DISSIMILAR_INTERFACE || typeA.symbol().isFinal()) && !typeA.isSubtypeOf(typeB);
        }
        if (typeA.symbol().isInterface()) {
            return true;
        }
        return !typeA.isSubtypeOf(typeB);
    }

    private void createIssue(Argument actual, Argument expected) {
        this.reportIssue((Tree)expected.expression, "Change the assertion arguments to not compare dissimilar types.", Collections.singletonList(new JavaFileScannerContext.Location("Actual", (Tree)actual.expression)), null);
    }

    static Type wrapperType(Type type) {
        if (type.isPrimitive()) {
            Type wrapperType = JUtils.primitiveWrapperType((Type)type);
            return wrapperType != null ? wrapperType : type;
        }
        return type;
    }

    static class Argument {
        final ExpressionTree expression;
        final Type expressionType;
        final Type type;

        Argument(MethodInvocationTree mit, int argumentIndex) {
            this.expression = (ExpressionTree)mit.arguments().get(argumentIndex);
            this.expressionType = this.expression.symbolType().erasure();
            Type expectedType = Argument.expectedArgumentType(mit, argumentIndex);
            this.type = expectedType.isUnknown() ? this.expressionType : (expectedType.isPrimitive() ? expectedType : AssertionTypesCheck.wrapperType(this.expressionType));
        }

        Argument(ExpressionTree expression, Type type) {
            this.expression = expression;
            this.expressionType = type;
            this.type = type;
        }

        boolean isArray() {
            return this.type.isArray();
        }

        boolean isNotArray() {
            return !this.type.isUnknown() && !this.type.isArray() && !this.type.is(AssertionTypesCheck.JAVA_LANG_OBJECT) && !this.isNullLiteral();
        }

        boolean isNullLiteral() {
            return this.expression.kind() == Tree.Kind.NULL_LITERAL;
        }

        boolean isPrimitive() {
            return this.expressionType.isPrimitive();
        }

        static Type expectedArgumentType(MethodInvocationTree mit, int argumentIndex) {
            if (!mit.symbol().isMethodSymbol()) {
                return Symbols.unknownType;
            }
            List parameterTypes = ((Symbol.MethodSymbol)mit.symbol()).parameterTypes();
            if (argumentIndex >= parameterTypes.size()) {
                return Symbols.unknownType;
            }
            return ((Type)parameterTypes.get(argumentIndex)).erasure();
        }
    }

    private static enum Option {
        ACCEPT_DISSIMILAR_INTERFACE,
        REJECT_DISSIMILAR_INTERFACE;

    }
}

