/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.checks.helpers.UnitTestUtils;
import org.sonar.java.collections.SetUtils;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5863")
public class AssertionCompareToSelfCheck
extends IssuableSubscriptionVisitor {
    private static final String ASSERT_ARRAY_EQUALS = "assertArrayEquals";
    private static final String ASSERT_EQUALS = "assertEquals";
    private static final String IS_EQUAL_TO = "isEqualTo";
    private static final MethodMatchers ASSERTJ_AND_FEST_ASSERT_SUBJECT_METHODS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"org.assertj.core.api.Assertions", "org.assertj.core.api.AssertionsForInterfaceTypes", "org.assertj.core.api.AssertionsForClassTypes"}).names(new String[]{"assertThat", "assertThatObject"}).addParametersMatcher(new String[]{"*"}).build(), MethodMatchers.create().ofTypes(new String[]{"org.fest.assertions.Assertions"}).names(new String[]{"assertThat"}).addParametersMatcher(new String[]{"*"}).build()});
    private static final MethodMatchers JUNIT5_ASSERTIONS = MethodMatchers.create().ofTypes(new String[]{"org.junit.jupiter.api.Assertions"}).names(new String[]{"assertArrayEquals", "assertEquals", "assertIterableEquals", "assertLinesMatch"}).addParametersMatcher(parameters -> parameters.size() >= 2).build();
    private static final MethodMatchers JUNIT4_ASSERTIONS_WITHOUT_MESSAGE = MethodMatchers.create().ofTypes(new String[]{"org.junit.Assert"}).names(new String[]{"assertArrayEquals", "assertEquals"}).addParametersMatcher(new String[]{"*", "*"}).build();
    private static final MethodMatchers JUNIT4_ASSERTIONS_WITH_MESSAGE = MethodMatchers.create().ofTypes(new String[]{"org.junit.Assert"}).names(new String[]{"assertArrayEquals", "assertEquals"}).addParametersMatcher(new String[]{"java.lang.String", "*", "*"}).build();
    private static final MethodMatchers ASSERTJ_AND_FEST_ASSERT_MESSAGE_METHODS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofSubTypes(new String[]{"org.assertj.core.api.AbstractAssert"}).names(new String[]{"as", "describedAs", "withFailMessage", "overridingErrorMessage"}).withAnyParameters().build(), MethodMatchers.create().ofSubTypes(new String[]{"org.fest.assertions.GenericAssert"}).names(new String[]{"as", "describedAs", "overridingErrorMessage"}).withAnyParameters().build()});
    private static final MethodMatchers ASSERTJ_AND_FEST_ASSERT_PREDICATES = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofSubTypes(new String[]{"org.assertj.core.api.AbstractAssert"}).names(new String[]{"contains", "containsAll", "containsAllEntriesOf", "containsAnyElementOf", "containsAnyOf", "containsExactly", "containsExactlyElementsOf", "containsExactlyEntriesOf", "containsExactlyInAnyOrder", "containsExactlyInAnyOrderEntriesOf", "containsIgnoringCase", "containsOnly", "containsOnlyElementsOf", "containsSequence", "containsSubsequence", "doesNotContain", "endsWith", "hasSameClassAs", "hasSameElementsAs", "hasSameHashCodeAs", "hasSameSizeAs", "isEqualTo", "isEqualToIgnoringCase", "isSameAs", "startsWith"}).addParametersMatcher(new String[]{"*"}).build(), MethodMatchers.create().ofSubTypes(new String[]{"org.fest.assertions.GenericAssert"}).names(new String[]{"contains", "containsExactly", "containsIgnoringCase", "containsOnly", "doesNotContain", "endsWith", "isEqualTo", "isEqualToIgnoringCase", "isSameAs", "startsWith"}).addParametersMatcher(new String[]{"*"}).build()});
    private static final Set<String> EQUALS_HASH_CODE_METHODS = SetUtils.immutableSetOf((Object[])new String[]{"assertEquals", "isEqualTo", "hasSameHashCodeAs"});
    private static final String MESSAGE = "Replace this assertion to not have the same actual and expected expression.";

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        MethodInvocationTree mit = (MethodInvocationTree)tree;
        if (JUNIT4_ASSERTIONS_WITH_MESSAGE.matches(mit)) {
            this.checkActualAndExpectedExpression(ExpressionUtils.methodName((MethodInvocationTree)mit).name(), (ExpressionTree)mit.arguments().get(2), (ExpressionTree)mit.arguments().get(1));
        } else if (JUNIT4_ASSERTIONS_WITHOUT_MESSAGE.matches(mit) || JUNIT5_ASSERTIONS.matches(mit)) {
            this.checkActualAndExpectedExpression(ExpressionUtils.methodName((MethodInvocationTree)mit).name(), (ExpressionTree)mit.arguments().get(1), (ExpressionTree)mit.arguments().get(0));
        } else if (ASSERTJ_AND_FEST_ASSERT_SUBJECT_METHODS.matches(mit)) {
            ExpressionTree actualExpression = (ExpressionTree)mit.arguments().get(0);
            AssertionCompareToSelfCheck.consecutiveMethodIgnoringMessageDescription(mit).filter(predicate -> predicate.arguments().size() == 1 && ASSERTJ_AND_FEST_ASSERT_PREDICATES.matches(predicate)).ifPresent(predicate -> this.checkActualAndExpectedExpression(ExpressionUtils.methodName((MethodInvocationTree)predicate).name(), actualExpression, (ExpressionTree)predicate.arguments().get(0)));
        }
    }

    private void checkActualAndExpectedExpression(String predicateMethodName, ExpressionTree actualExpression, ExpressionTree expectedExpression) {
        if (ExpressionsHelper.alwaysReturnSameValue(actualExpression) && SyntacticEquivalence.areEquivalent((Tree)actualExpression, (Tree)expectedExpression) && !AssertionCompareToSelfCheck.isLegitimateSelfComparison(predicateMethodName, actualExpression)) {
            List<JavaFileScannerContext.Location> secondaryLocations = Collections.singletonList(new JavaFileScannerContext.Location("actual", (Tree)actualExpression));
            this.reportIssue((Tree)expectedExpression, MESSAGE, secondaryLocations, null);
        }
    }

    private static boolean isLegitimateSelfComparison(String comparisonMethodName, ExpressionTree actualExpression) {
        Type actualExpressionType = actualExpression.symbolType();
        return EQUALS_HASH_CODE_METHODS.contains(comparisonMethodName) && !AssertionCompareToSelfCheck.isPrimitiveOrNull(actualExpressionType) && UnitTestUtils.isInUnitTestRelatedToObjectMethods(actualExpression);
    }

    private static boolean isPrimitiveOrNull(Type actualExpressionType) {
        return actualExpressionType.isPrimitive() || "null".equals(actualExpressionType.symbol().name());
    }

    private static Optional<MethodInvocationTree> consecutiveMethodIgnoringMessageDescription(MethodInvocationTree mit) {
        Optional<MethodInvocationTree> consecutiveMethod = MethodTreeUtils.consecutiveMethodInvocation((Tree)mit);
        if (consecutiveMethod.isPresent() && ASSERTJ_AND_FEST_ASSERT_MESSAGE_METHODS.matches(consecutiveMethod.get())) {
            return AssertionCompareToSelfCheck.consecutiveMethodIgnoringMessageDescription(consecutiveMethod.get());
        }
        return consecutiveMethod;
    }
}

