/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5876")
public class SpringSessionFixationCheck
extends AbstractMethodDetection {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes(new String[]{"org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer$SessionFixationConfigurer"}).names(new String[]{"none"}).addWithoutParametersMatcher().build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree methodInvocation) {
        this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)methodInvocation), "Create a new session during user authentication to prevent session fixation attacks.");
    }
}

